/*
 * Decompiled with CFR 0.152.
 */
package in.succinct.plugins.ecommerce.integration.fedex;

import com.fedex.track.stub.Address;
import com.fedex.track.stub.CarrierCodeType;
import com.fedex.track.stub.ClientDetail;
import com.fedex.track.stub.CompletedTrackDetail;
import com.fedex.track.stub.CustomerExceptionRequestDetail;
import com.fedex.track.stub.DeliveryOptionEligibilityDetail;
import com.fedex.track.stub.Money;
import com.fedex.track.stub.Notification;
import com.fedex.track.stub.NotificationSeverityType;
import com.fedex.track.stub.TrackChargeDetail;
import com.fedex.track.stub.TrackDetail;
import com.fedex.track.stub.TrackEvent;
import com.fedex.track.stub.TrackIdentifierType;
import com.fedex.track.stub.TrackOtherIdentifierDetail;
import com.fedex.track.stub.TrackPackageIdentifier;
import com.fedex.track.stub.TrackPortType;
import com.fedex.track.stub.TrackReply;
import com.fedex.track.stub.TrackRequest;
import com.fedex.track.stub.TrackRequestProcessingOptionType;
import com.fedex.track.stub.TrackSelectionDetail;
import com.fedex.track.stub.TrackServiceLocator;
import com.fedex.track.stub.TrackStatusAncillaryDetail;
import com.fedex.track.stub.TrackStatusDetail;
import com.fedex.track.stub.TrackingDateOrTimestamp;
import com.fedex.track.stub.TrackingDateOrTimestampType;
import com.fedex.track.stub.TransactionDetail;
import com.fedex.track.stub.VersionId;
import com.fedex.track.stub.WebAuthenticationCredential;
import com.fedex.track.stub.WebAuthenticationDetail;
import com.fedex.track.stub.Weight;
import com.venky.core.date.DateUtils;
import com.venky.core.log.SWFLogger;
import com.venky.core.util.ObjectUtil;
import com.venky.swf.db.Database;
import com.venky.swf.routing.Config;
import com.venky.swf.sql.Conjunction;
import com.venky.swf.sql.Expression;
import com.venky.swf.sql.Operator;
import com.venky.swf.sql.Select;
import in.succinct.plugins.ecommerce.db.model.order.Manifest;
import in.succinct.plugins.ecommerce.db.model.order.Order;
import in.succinct.plugins.ecommerce.db.model.order.OrderAttribute;
import in.succinct.plugins.ecommerce.db.model.order.OrderIntransitEvent;
import in.succinct.plugins.ecommerce.db.model.participation.PreferredCarrier;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;

public class TrackWebServiceClient {
    Manifest manifest = null;
    PreferredCarrier carrier = null;
    SWFLogger cat = Config.instance().getLogger(this.getClass().getName());

    public TrackWebServiceClient(Manifest manifest) {
        this.manifest = manifest;
        this.carrier = manifest.getPreferredCarrier();
    }

    public void track() {
        Set<Long> orderIds = this.manifest.getOrderIdsPendingDelivery();
        HashMap<String, Long> trackingNumbers = new HashMap<String, Long>();
        Select s = new Select(new String[0]).from(new Class[]{OrderAttribute.class});
        Expression where = new Expression(s.getPool(), Conjunction.AND);
        where.add(new Expression(s.getPool(), "NAME", Operator.EQ, (Object[])new String[]{"tracking_number"}));
        where.add(new Expression(s.getPool(), "ORDER_ID", Operator.IN, orderIds.toArray()));
        List orderAttributes = new Select(new String[0]).from(new Class[]{OrderAttribute.class}).where(where).execute();
        orderAttributes.forEach(oa -> trackingNumbers.put(oa.getValue(), oa.getOrderId()));
        Stack batches = new Stack();
        int batchSize = 30;
        for (String string : trackingNumbers.keySet()) {
            if (batches.isEmpty() || ((Set)batches.peek()).size() >= batchSize) {
                batches.push(new HashSet());
            }
            ((Set)batches.peek()).add(string);
        }
        for (Set set : batches) {
            TrackRequest request = new TrackRequest();
            request.setClientDetail(this.createClientDetail());
            request.setWebAuthenticationDetail(this.createWebAuthenticationDetail());
            TransactionDetail transactionDetail = new TransactionDetail();
            transactionDetail.setCustomerTransactionId(this.manifest.getManifestNumber());
            request.setTransactionDetail(transactionDetail);
            VersionId versionId = new VersionId("trck", 16, 0, 0);
            request.setVersion(versionId);
            ArrayList<TrackSelectionDetail> list = new ArrayList<TrackSelectionDetail>();
            for (String trackingNumber : set) {
                TrackSelectionDetail selectionDetail = new TrackSelectionDetail();
                selectionDetail.setCarrierCode(CarrierCodeType.FDXE);
                TrackPackageIdentifier packageIdentifier = new TrackPackageIdentifier();
                packageIdentifier.setType(TrackIdentifierType.TRACKING_NUMBER_OR_DOORTAG);
                packageIdentifier.setValue(trackingNumber);
                selectionDetail.setPackageIdentifier(packageIdentifier);
                list.add(selectionDetail);
            }
            request.setSelectionDetails(list.toArray(new TrackSelectionDetail[0]));
            TrackRequestProcessingOptionType processingOption = TrackRequestProcessingOptionType.INCLUDE_DETAILED_SCANS;
            request.setProcessingOptions(new TrackRequestProcessingOptionType[]{processingOption});
            try {
                TrackServiceLocator service = new TrackServiceLocator();
                this.updateEndPoint(service);
                TrackPortType port = service.getTrackServicePort();
                TrackReply reply = port.track(request);
                if (this.printNotifications(reply.getNotifications())) {
                    this.printCompletedTrackDetail(reply.getCompletedTrackDetails(), trackingNumbers);
                }
                if (!this.isResponseOk(reply.getHighestSeverity())) continue;
                this.cat.info("--Track Reply--");
            }
            catch (Exception e) {
                this.cat.log(Level.WARNING, "", (Throwable)e);
            }
        }
    }

    private void printCompletedTrackDetail(CompletedTrackDetail[] ctd, Map<String, Long> trackingNumberOrderMap) {
        for (int i = 0; i < ctd.length; ++i) {
            boolean cont = true;
            this.cat.info("--Completed Tracking Detail--");
            if (ctd[i].getNotifications() != null) {
                this.cat.info("  Completed Track Detail Notifications--");
                cont = this.printNotifications(ctd[i].getNotifications());
                this.cat.info("  Completed Track Detail Notifications--");
            }
            if (cont) {
                this.print("DuplicateWayBill", ctd[i].getDuplicateWaybill());
                this.print("Track Details Count", ctd[i].getTrackDetailsCount());
                if (ctd[i].getMoreData().booleanValue()) {
                    this.cat.info("  Additional package data not yet retrieved");
                    if (ctd[i].getPagingToken() != null) {
                        this.print("  Paging Token", ctd[i].getPagingToken());
                    }
                }
                this.printTrackDetail(ctd[i].getTrackDetails(), trackingNumberOrderMap);
            }
            this.cat.info("--Completed Tracking Detail--");
        }
    }

    private void printTrackDetail(TrackDetail[] td, Map<String, Long> trackingOrderIdMap) {
        for (int i = 0; i < td.length; ++i) {
            boolean cont = true;
            this.cat.info("--Track Details--");
            Order order = null;
            if (td[i].getNotification() != null) {
                this.cat.info("  Track Detail Notification--");
                cont = this.printNotifications(td[i].getNotification());
                this.cat.info("  Track Detail Notification--");
            }
            if (!cont) continue;
            this.print("Tracking Number", td[i].getTrackingNumber());
            Long orderId = trackingOrderIdMap.get(td[i].getTrackingNumber());
            order = (Order)Database.getTable(Order.class).get(orderId.longValue());
            this.print("Carrier code", td[i].getCarrierCode());
            if (td[i].getService() != null && td[i].getService().getType() != null && td[i].getService().getDescription() != null) {
                this.print("Service", td[i].getService().getType());
                this.print("Description", td[i].getService().getDescription());
            }
            if (td[i].getOtherIdentifiers() != null) {
                this.cat.info("--Track Package Identifer--");
                this.printTrackOtherIdentifierDetail(td[i].getOtherIdentifiers());
                this.cat.info("--Track Package Identifer--");
            }
            if (td[i].getStatusDetail() != null) {
                this.cat.info("--Status Details--");
                this.printStatusDetail(td[i].getStatusDetail());
                this.cat.info("--Status Details--");
            }
            if (td[i].getOriginLocationAddress() != null) {
                this.cat.info("--Origin Location--");
                this.print(td[i].getOriginLocationAddress());
                this.cat.info("--Origin Location--");
            }
            if (td[i].getDestinationAddress() != null) {
                this.cat.info("--Destination Location--");
                this.printDestinationInformation(td[i]);
                this.cat.info("--Destination Location--");
            }
            if (td[i].getActualDeliveryAddress() != null) {
                this.cat.info("--Delivery Address--");
                this.print(td[i].getActualDeliveryAddress());
                this.cat.info("--Delivery Address--");
            }
            Timestamp deliveryTimestamp = null;
            Timestamp pickUpTimestamp = null;
            DateFormat ISO_8601_24H_FULL_FORMAT = DateUtils.getFormat((String)"yyyy-MM-dd'T'HH:mm:ssXXX");
            if (td[i].getDatesOrTimes() != null) {
                TrackingDateOrTimestamp[] dates = td[i].getDatesOrTimes();
                for (int j = 0; j < dates.length; ++j) {
                    if (dates[j].getType() == TrackingDateOrTimestampType.ACTUAL_DELIVERY) {
                        order.deliver();
                        try {
                            deliveryTimestamp = new Timestamp(ISO_8601_24H_FULL_FORMAT.parse(dates[j].getDateOrTimestamp()).getTime());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (dates[j].getType() == TrackingDateOrTimestampType.ACTUAL_PICKUP) {
                        try {
                            pickUpTimestamp = new Timestamp(ISO_8601_24H_FULL_FORMAT.parse(dates[j].getDateOrTimestamp()).getTime());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.print(dates[j].getType().getValue(), dates[j].getDateOrTimestamp());
                }
            }
            if (td[i].getDeliveryAttempts().shortValue() > 0) {
                this.cat.info("--Delivery Information--");
                this.printDeliveryInformation(td[i]);
                this.cat.info("--Delivery Information--");
            }
            if (td[i].getCustomerExceptionRequests() != null) {
                this.cat.info("--Customer Exception Information--");
                this.printCustomerExceptionRequests(td[i].getCustomerExceptionRequests());
                this.cat.info("--Customer Exception Information--");
            }
            if (td[i].getCharges() != null) {
                this.cat.info("--Charges--");
                this.printCharges(td[i].getCharges());
                this.cat.info("--Charges--");
            }
            if (td[i].getEvents() != null) {
                this.cat.info("--Tracking Events--");
                this.printTrackEvents(td[i].getEvents(), order, pickUpTimestamp, deliveryTimestamp);
                this.cat.info("--Tracking Events--");
            }
            this.cat.info("--Track Details--");
        }
    }

    private void printCustomerExceptionRequests(CustomerExceptionRequestDetail[] exceptions) {
        if (exceptions != null) {
            for (int i = 0; i < exceptions.length; ++i) {
                CustomerExceptionRequestDetail exception = exceptions[i];
                this.print("Exception Id", exception.getId());
                this.print("Excpetion Status Code", exception.getStatusCode());
                this.print("Excpetion Status Description", exception.getStatusDescription());
                if (exception.getCreateTime() == null) continue;
                this.cat.info("  Customer Exception Date--");
                this.print(exception.getCreateTime());
                this.cat.info("  Customer Exception Date--");
            }
        }
    }

    private void printTrackEvents(TrackEvent[] events, Order order, Timestamp pickTS, Timestamp deliveryTS) {
        DateFormat ISO_8601_24H_FULL_FORMAT = DateUtils.getFormat((String)"yyyy-MM-dd'T'HH:mm:ssXXX");
        if (events != null) {
            int eventSeqNo = 0;
            if (events.length > 0) {
                order.getIntransitUpdates().forEach(e -> e.destroy());
            }
            for (int i = events.length - 1; i > 0; --i) {
                TrackEvent event = events[i];
                OrderIntransitEvent oie = (OrderIntransitEvent)Database.getTable(OrderIntransitEvent.class).newRecord();
                oie.setEventSeqNo(eventSeqNo);
                oie.setOrderId(order.getId());
                if (ObjectUtil.equals((Object)event.getEventType(), (Object)"AR") || ObjectUtil.equals((Object)event.getEventType(), (Object)"DL")) {
                    oie.setEventType("Arrived");
                } else {
                    if (!ObjectUtil.equals((Object)event.getEventType(), (Object)"DP") && !ObjectUtil.equals((Object)event.getEventType(), (Object)"PU")) continue;
                    oie.setEventType("Left");
                }
                if (ObjectUtil.equals((Object)event.getEventType(), (Object)"DL")) {
                    oie.setEventTimestamp(deliveryTS);
                } else if (ObjectUtil.equals((Object)event.getEventType(), (Object)"PU")) {
                    oie.setEventTimestamp(pickTS);
                } else {
                    oie.setEventTimestamp(new Timestamp(event.getTimestamp().getTimeInMillis()));
                }
                oie.setEventDescription(event.getEventDescription());
                this.print("Event no. ", i);
                this.print(event.getTimestamp());
                if (event.getEventType() != null) {
                    this.print("Type", event.getEventType());
                }
                this.print("Station Id", event.getStationId());
                this.print("Exception Code", event.getStatusExceptionCode());
                this.print("", event.getStatusExceptionDescription());
                this.print("Description", event.getEventDescription());
                if (event.getAddress() != null) {
                    this.cat.info("  Event Address--");
                    this.printAddress(oie, event.getAddress());
                    this.cat.info("  Event Address--");
                }
                oie.save();
                ++eventSeqNo;
            }
        }
    }

    private void printStatusDetail(TrackStatusDetail tsd) {
        if (tsd != null) {
            this.print(tsd.getCreationTime());
            this.print("Code", tsd.getCode());
            if (tsd.getLocation() != null) {
                this.cat.info("--Location Address Detail--");
                this.print(tsd.getLocation());
                this.cat.info("--Location Address Detail--");
            }
            if (tsd.getAncillaryDetails() != null) {
                this.cat.info("--Ancillary Details--");
                this.printAncillaryDetails(tsd.getAncillaryDetails());
                this.cat.info("--Ancillary Details--");
            }
        }
    }

    private void printAncillaryDetails(TrackStatusAncillaryDetail[] details) {
        if (details != null) {
            for (int i = 0; i < details.length; ++i) {
                if (details[i] == null || details[i].getReason() == null || details[i].getReasonDescription() == null) continue;
                this.print(details[i].getReason(), details[i].getReasonDescription());
            }
        }
    }

    private void printDestinationInformation(TrackDetail td) {
        if (td.getDestinationAddress() != null) {
            this.print(td.getDestinationAddress());
        }
        this.print("Destination Type", td.getDestinationLocationType());
        this.print("Service Area", td.getDestinationServiceArea());
        this.print("Service Area Description", td.getDestinationServiceAreaDescription());
        this.print("Station Id", td.getDestinationStationId());
        this.print("Destination Timezone Offset", td.getDestinationLocationTimeZoneOffset());
    }

    private void printDeliveryOptionEligibility(DeliveryOptionEligibilityDetail[] options) {
        for (int i = 0; i < options.length; ++i) {
            DeliveryOptionEligibilityDetail option = options[i];
            if (option == null) continue;
            this.print(option.getOption(), option.getEligibility());
        }
    }

    private void printDeliveryInformation(TrackDetail td) {
        this.cat.info("Delivery attempts: " + td.getDeliveryAttempts());
        this.print("Delivery Location", td.getDeliveryLocationDescription());
        this.print("Delivery Signature", td.getDeliverySignatureName());
        if (td.getDeliveryOptionEligibilityDetails() != null) {
            this.cat.info("Delivery Options");
            this.printDeliveryOptionEligibility(td.getDeliveryOptionEligibilityDetails());
        }
    }

    private void printTrackOtherIdentifierDetail(TrackOtherIdentifierDetail[] id) {
        if (id != null) {
            for (int i = 0; i < id.length; ++i) {
                if (id[i].getPackageIdentifier() == null) continue;
                this.print(id[i].getPackageIdentifier().getType(), id[i].getPackageIdentifier().getValue());
            }
        }
    }

    private void printTime(Calendar calendar) {
        if (calendar != null) {
            int month = calendar.get(2) + 1;
            int day = calendar.get(5);
            int year = calendar.get(1);
            String date = new String(year + "-" + month + "-" + day);
            this.print("Date", date);
            this.printDOW(calendar);
        }
    }

    private void printAddress(OrderIntransitEvent oie, Address address) {
        StringBuilder location = new StringBuilder();
        this.print("__________________________________");
        if (address.getStreetLines() != null) {
            String[] streetLines = address.getStreetLines();
            for (int i = 0; i < streetLines.length; ++i) {
                if (streetLines[i] == null) continue;
                this.print("Street", streetLines[i]);
            }
        }
        location.append(address.getCity()).append(",").append(address.getStateOrProvinceCode()).append(",").append(address.getPostalCode());
        if (oie != null) {
            oie.setLocation(location.toString());
        }
        this.print("City", address.getCity());
        this.print("State or Province Code", address.getStateOrProvinceCode());
        this.print("Postal Code", address.getPostalCode());
        this.print("Country Code", address.getCountryCode());
        if (address.getResidential() != null) {
            if (address.getResidential().booleanValue()) {
                this.print("Address Type", "Residential");
            } else {
                this.print("Address Type", "Commercial");
            }
        }
        this.print("__________________________________");
    }

    private void printDOW(Calendar calendar) {
        if (calendar != null) {
            String day;
            switch (calendar.get(7)) {
                case 1: {
                    day = "Sunday";
                    break;
                }
                case 2: {
                    day = "Monday";
                    break;
                }
                case 3: {
                    day = "Tuesday";
                    break;
                }
                case 4: {
                    day = "Wedensday";
                    break;
                }
                case 5: {
                    day = "Thursday";
                    break;
                }
                case 6: {
                    day = "Friday";
                    break;
                }
                case 7: {
                    day = "Saturday";
                    break;
                }
                default: {
                    day = "Invalid Date";
                }
            }
            this.print("Day of Week", day);
        }
    }

    private boolean isResponseOk(NotificationSeverityType notificationSeverityType) {
        if (notificationSeverityType == null) {
            return false;
        }
        return notificationSeverityType.equals(NotificationSeverityType.WARNING) || notificationSeverityType.equals(NotificationSeverityType.NOTE) || notificationSeverityType.equals(NotificationSeverityType.SUCCESS);
    }

    private PreferredCarrier getCourier(Manifest manifest) {
        return manifest.getPreferredCarrier();
    }

    private ClientDetail createClientDetail() {
        ClientDetail clientDetail = new ClientDetail();
        String accountNumber = this.carrier.getAccountNumber();
        String meterNumber = this.carrier.getMeterNumber();
        clientDetail.setAccountNumber(accountNumber);
        clientDetail.setMeterNumber(meterNumber);
        return clientDetail;
    }

    private WebAuthenticationDetail createWebAuthenticationDetail() {
        WebAuthenticationCredential userCredential = new WebAuthenticationCredential();
        userCredential.setKey(this.carrier.getApiKey());
        userCredential.setPassword(this.carrier.getPassword());
        WebAuthenticationCredential parentCredential = null;
        Boolean useParentCredential = false;
        if (useParentCredential.booleanValue()) {
            String parentKey = System.getProperty("parentkey");
            String parentPassword = System.getProperty("parentpassword");
            if (parentKey == null) {
                parentKey = "XXX";
            }
            if (parentPassword == null) {
                parentPassword = "XXX";
            }
            parentCredential = new WebAuthenticationCredential();
            parentCredential.setKey(parentKey);
            parentCredential.setPassword(parentPassword);
        }
        return new WebAuthenticationDetail(parentCredential, userCredential);
    }

    private void updateEndPoint(TrackServiceLocator serviceLocator) {
        String endPoint = this.carrier.getIntegrationEndPoint();
        if (endPoint != null) {
            serviceLocator.setTrackServicePortEndpointAddress(endPoint);
        }
    }

    private void printCharges(TrackChargeDetail[] charges) {
        if (charges != null) {
            for (int i = 0; i < charges.length; ++i) {
                this.print("Charge Type", charges[i].getType());
                this.printMoney(charges[i].getChargeAmount());
            }
        }
    }

    private void printMoney(Money money) {
        if (money != null) {
            String currency = money.getCurrency();
            String amount = money.getAmount().toString();
            this.print("Charge", currency + " " + amount);
        }
    }

    private boolean printNotifications(Object n) {
        boolean cont = true;
        if (n != null) {
            Notification[] notifications = null;
            Notification notification = null;
            if (n instanceof Notification[]) {
                notifications = (Notification[])n;
                if (notifications == null || notifications.length == 0) {
                    this.cat.info("  No notifications returned");
                }
                for (int i = 0; i < notifications.length; ++i) {
                    this.printNotification(notifications[i]);
                    if (this.success(notifications[i])) continue;
                    cont = false;
                }
            } else if (n instanceof Notification) {
                notification = (Notification)n;
                this.printNotification(notification);
                if (!this.success(notification)) {
                    cont = false;
                }
            }
        }
        return cont;
    }

    private void printNotification(Notification notification) {
        NotificationSeverityType nst;
        if (notification == null) {
            this.cat.info("null");
        }
        this.print("  Severity", (nst = notification.getSeverity()) == null ? "null" : nst.getValue());
        this.print("  Code", notification.getCode());
        this.print("  Message", notification.getMessage());
        this.print("  Source", notification.getSource());
    }

    private boolean success(Notification notification) {
        Boolean cont = true;
        if (notification != null && (notification.getSeverity() == NotificationSeverityType.FAILURE || notification.getSeverity() == NotificationSeverityType.ERROR)) {
            cont = false;
        }
        return cont;
    }

    private void print(Object k, Object v) {
        if (k == null || v == null) {
            return;
        }
        String key = k instanceof String ? (String)k : k.toString();
        String value = v instanceof String ? (String)v : v.toString();
        this.cat.info("  " + key + ": " + value);
    }

    private void print(Object o) {
        if (o != null) {
            if (o instanceof String) {
                this.cat.info((String)o);
            } else if (o instanceof Address) {
                this.printAddress(null, (Address)o);
            } else if (o instanceof Calendar) {
                this.printTime((Calendar)o);
            } else {
                this.cat.info(o.toString());
            }
        }
    }

    private void printWeight(String msg, Weight weight) {
        if (msg == null || weight == null) {
            return;
        }
        this.cat.info(msg + ": " + weight.getValue() + " " + weight.getUnits());
    }

    private String getSystemProperty(String property) {
        String returnProperty = System.getProperty(property);
        if (returnProperty == null) {
            return "XXX";
        }
        return returnProperty;
    }
}

