/*
 * Decompiled with CFR 0.152.
 */
package in.succinct.plugins.ecommerce.integration.humbhionline;

import com.venky.cache.Cache;
import com.venky.core.math.DoubleHolder;
import com.venky.core.math.DoubleUtils;
import com.venky.core.util.Bucket;
import com.venky.core.util.ObjectUtil;
import com.venky.swf.db.Database;
import com.venky.swf.db.annotations.column.ui.mimes.MimeType;
import com.venky.swf.db.model.Model;
import com.venky.swf.db.model.io.ModelIOFactory;
import com.venky.swf.db.model.reflection.ModelReflector;
import com.venky.swf.integration.FormatHelper;
import com.venky.swf.integration.api.Call;
import com.venky.swf.integration.api.HttpMethod;
import com.venky.swf.integration.api.InputFormat;
import com.venky.swf.plugins.background.core.Task;
import com.venky.swf.plugins.background.core.TaskManager;
import com.venky.swf.plugins.collab.db.model.participants.admin.Address;
import com.venky.swf.routing.Config;
import com.venky.swf.sql.Expression;
import com.venky.swf.sql.Operator;
import com.venky.swf.sql.Select;
import in.succinct.plugins.ecommerce.db.model.catalog.Item;
import in.succinct.plugins.ecommerce.db.model.inventory.Inventory;
import in.succinct.plugins.ecommerce.db.model.inventory.Sku;
import in.succinct.plugins.ecommerce.db.model.order.Order;
import in.succinct.plugins.ecommerce.db.model.order.OrderAddress;
import in.succinct.plugins.ecommerce.db.model.order.OrderLine;
import in.succinct.plugins.ecommerce.db.model.participation.Company;
import in.succinct.plugins.ecommerce.db.model.participation.Facility;
import in.succinct.plugins.ecommerce.db.model.participation.MarketPlaceIntegration;
import in.succinct.plugins.ecommerce.db.model.participation.User;
import in.succinct.plugins.ecommerce.integration.MarketPlace;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class HumBhiOnline
implements MarketPlace,
MarketPlace.WarehouseActionHandler,
MarketPlace.UserActionHandler {
    private static Map<Long, HumBhiOnline> instance = new Cache<Long, HumBhiOnline>(){

        protected HumBhiOnline getValue(Long marketPlaceIntegrationId) {
            return new HumBhiOnline(marketPlaceIntegrationId);
        }
    };
    private MarketPlaceIntegration marketPlaceIntegration;

    private HumBhiOnline(Long marketPlaceIntegrationId) {
        this((MarketPlaceIntegration)Database.getTable(MarketPlaceIntegration.class).get(marketPlaceIntegrationId.longValue()));
    }

    private HumBhiOnline(MarketPlaceIntegration marketPlaceIntegration) {
        this.marketPlaceIntegration = marketPlaceIntegration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HumBhiOnline getInstance(MarketPlaceIntegration marketPlaceIntegration) {
        if (!instance.containsKey(marketPlaceIntegration.getId())) {
            Map<Long, HumBhiOnline> map = instance;
            synchronized (map) {
                if (!instance.containsKey(marketPlaceIntegration.getId())) {
                    instance.put(marketPlaceIntegration.getId(), new HumBhiOnline(marketPlaceIntegration));
                }
            }
        }
        return instance.get(marketPlaceIntegration.getId());
    }

    @Override
    public long getFacilityId() {
        return this.marketPlaceIntegration.getFacilityId();
    }

    @Override
    public String getOrderPrefix() {
        return this.getClass().getSimpleName() + "-";
    }

    public String getUserPrefix() {
        return "HUMBOL-";
    }

    @Override
    public MarketPlace.WarehouseActionHandler getWarehouseActionHandler() {
        return this;
    }

    @Override
    public MarketPlace.UserActionHandler getUserActionHandler() {
        return this;
    }

    public String getBaseUrl() {
        return this.marketPlaceIntegration.getBaseUrl();
    }

    @Override
    public void sync(Inventory inventory) {
        JSONObject params = new JSONObject();
        JSONObject adjustmentRequest = new JSONObject();
        params.put((Object)"AdjustmentRequest", (Object)adjustmentRequest);
        JSONObject companyJson = new JSONObject();
        companyJson.put((Object)"Name", (Object)"MANDI");
        Sku sku = inventory.getSku();
        Item item = sku.getItem();
        JSONObject itemJson = new JSONObject();
        itemJson.put((Object)"Name", (Object)(sku.getPackagingUOMId() == null ? inventory.getSku().getName() : item.getName()));
        if (!ObjectUtil.isVoid((Object)item.getHsn())) {
            JSONObject assetCodeJson = new JSONObject();
            assetCodeJson.put((Object)"Code", (Object)item.getHsn());
            itemJson.put((Object)"AssetCode", (Object)assetCodeJson);
        }
        itemJson.put((Object)"Company", (Object)companyJson);
        JSONObject uomJson = new JSONObject();
        uomJson.put((Object)"Measures", (Object)"Packaging");
        uomJson.put((Object)"Name", (Object)(sku.getPackagingUOMId() == null ? "Each" : sku.getPackagingUOM().getName()));
        JSONObject skuJson = new JSONObject();
        skuJson.put((Object)"Item", (Object)itemJson);
        skuJson.put((Object)"PackagingUOM", (Object)uomJson);
        skuJson.put((Object)"Name", (Object)(itemJson.get((Object)"Name") + "-" + uomJson.get((Object)"Name")));
        skuJson.put((Object)"SkuCode", (Object)sku.getSkuCode());
        skuJson.put((Object)"Published", (Object)sku.isPublished());
        JSONObject faciltyJson = new JSONObject();
        faciltyJson.put((Object)"Id", (Object)this.marketPlaceIntegration.getChannelFacilityRef());
        JSONObject inventoryJson = new JSONObject();
        inventoryJson.put((Object)"Sku", (Object)skuJson);
        inventoryJson.put((Object)"Facility", (Object)faciltyJson);
        inventoryJson.put((Object)"Company", (Object)companyJson);
        inventoryJson.put((Object)"Infinite", (Object)inventory.isPublished());
        inventoryJson.put((Object)"MaxRetailPrice", (Object)sku.getMaxRetailPrice());
        inventoryJson.put((Object)"SellingPrice", (Object)sku.getSellingPrice());
        adjustmentRequest.put((Object)"Inventory", (Object)inventoryJson);
        adjustmentRequest.put((Object)"AdjustmentQuantity", (Object)0.0);
        adjustmentRequest.put((Object)"Comment", (Object)"Adjust");
        Map<String, String> headers = this.getDefaultHeaders();
        Call call = new Call();
        if (call.url(this.marketPlaceIntegration.getBaseUrl() + "/api/adjust").inputFormat(InputFormat.JSON).input((Object)params).method(HttpMethod.POST).headers(headers).hasErrors()) {
            throw new RuntimeException(call.getError());
        }
        if (!ObjectUtil.isVoid((Object)sku.getSmallImageUrl())) {
            JSONObject attachmentParams = new JSONObject();
            JSONObject attachmentJSON = new JSONObject();
            attachmentParams.put((Object)"Attachment", (Object)attachmentJSON);
            if (sku.getSmallImageUrl().contains("/attachment")) {
                attachmentJSON.put((Object)"UploadUrl", (Object)(Config.instance().getServerBaseUrl() + sku.getSmallImageUrl()));
            } else {
                attachmentJSON.put((Object)"UploadUrl", (Object)(Config.instance().getServerBaseUrl() + "/resources/cdn/wiggles/image/" + sku.getSmallImageUrl()));
            }
            attachmentJSON.put((Object)"Sku", (Object)skuJson);
            call = new Call();
            if (call.url(this.marketPlaceIntegration.getBaseUrl() + "/attachments/save").inputFormat(InputFormat.JSON).input((Object)attachmentParams).method(HttpMethod.POST).headers(headers).hasErrors()) {
                throw new RuntimeException(call.getError());
            }
        }
    }

    private Map<String, String> getDefaultHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", MimeType.APPLICATION_JSON.toString());
        headers.put("Accept", MimeType.APPLICATION_JSON.toString());
        headers.put("ApiKey", this.getApiKey());
        return headers;
    }

    public String getApiKey() {
        JSONObject loginJson = new JSONObject();
        JSONObject userJson = new JSONObject();
        loginJson.put((Object)"User", (Object)userJson);
        userJson.put((Object)"PhoneNumber", (Object)this.marketPlaceIntegration.getUsername());
        userJson.put((Object)"Password", (Object)this.marketPlaceIntegration.getPassword());
        JSONObject response = (JSONObject)new Call().url(this.marketPlaceIntegration.getBaseUrl() + "/login").inputFormat(InputFormat.JSON).input((Object)loginJson).header("content-type", MimeType.APPLICATION_JSON.toString()).method(HttpMethod.POST).getResponseAsJson();
        if (response != null) {
            return (String)((JSONObject)response.get((Object)"User")).get((Object)"ApiKey");
        }
        return null;
    }

    @Override
    public void pullOrders(Order lastOrder) {
        String hboOrderNumber = lastOrder == null ? "0" : lastOrder.getReference().substring(this.getOrderPrefix().length());
        String maxOrderNumber = String.valueOf(Math.pow(10.0, hboOrderNumber.length()) - 1.0);
        JSONObject params = new JSONObject();
        params.put((Object)"q", (Object)("FACILITY_ID:" + this.marketPlaceIntegration.getChannelFacilityRef() + " AND OPEN:Y AND ID:[" + hboOrderNumber + " TO " + maxOrderNumber + "]"));
        JSONObject orders = (JSONObject)new Call().url(this.marketPlaceIntegration.getBaseUrl() + "/orders/search").method(HttpMethod.GET).inputFormat(InputFormat.FORM_FIELDS).headers(this.getDefaultHeaders()).input((Object)params).getResponseAsJson();
        JSONArray orderList = (JSONArray)orders.get((Object)"Orders");
        ArrayList<BookOrder> tasks = new ArrayList<BookOrder>();
        for (int i = 0; i < orderList.size(); ++i) {
            JSONObject orderJson = (JSONObject)orderList.get(i);
            tasks.add(new BookOrder(orderJson, this.marketPlaceIntegration));
        }
        TaskManager.instance().executeAsync(tasks, false);
    }

    public String getMarketPlaceOrderNumber(Order order) {
        if (!((String)order.getReflector().getJdbcTypeHelper().getTypeRef(String.class).getTypeConverter().valueOf((Object)order.getReference())).startsWith(this.getOrderPrefix())) {
            return null;
        }
        return order.getReference().substring(this.getOrderPrefix().length());
    }

    @Override
    public void pack(Order order) {
        String hboOrderNumber = this.getMarketPlaceOrderNumber(order);
        if (ObjectUtil.isVoid((Object)hboOrderNumber)) {
            return;
        }
        Call call = new Call().url(this.marketPlaceIntegration.getBaseUrl() + "/orders/pack/" + hboOrderNumber).method(HttpMethod.GET).headers(this.getDefaultHeaders());
        if (call.hasErrors()) {
            throw new RuntimeException(call.getError());
        }
    }

    @Override
    public void ship(Order order) {
        String hboOrderNumber = this.getMarketPlaceOrderNumber(order);
        if (ObjectUtil.isVoid((Object)hboOrderNumber)) {
            return;
        }
        Call call = new Call().url(this.marketPlaceIntegration.getBaseUrl() + "/orders/ship/" + hboOrderNumber).method(HttpMethod.GET).headers(this.getDefaultHeaders());
        if (call.hasErrors()) {
            throw new RuntimeException(call.getError());
        }
    }

    @Override
    public void deliver(Order order) {
        String hboOrderNumber = this.getMarketPlaceOrderNumber(order);
        if (ObjectUtil.isVoid((Object)hboOrderNumber)) {
            return;
        }
        Call call = new Call().url(this.marketPlaceIntegration.getBaseUrl() + "/orders/deliver/" + hboOrderNumber).method(HttpMethod.GET).headers(this.getDefaultHeaders());
        if (call.hasErrors()) {
            throw new RuntimeException(call.getError());
        }
    }

    @Override
    public void reject(OrderLine orderLine) {
        String hboOrderNumber = this.getMarketPlaceOrderNumber(orderLine.getOrder());
        if (ObjectUtil.isVoid((Object)hboOrderNumber)) {
            return;
        }
        String hboOrderLineId = orderLine.getChannelOrderLineRef();
        Call call = new Call().url(this.marketPlaceIntegration.getBaseUrl() + "/order_lines/reject/" + hboOrderLineId).method(HttpMethod.GET).headers(this.getDefaultHeaders());
        if (call.hasErrors()) {
            throw new RuntimeException(call.getError());
        }
    }

    @Override
    public void startCount() {
        Call call = new Call().url(this.marketPlaceIntegration.getBaseUrl() + "/facilities/startCount/" + this.marketPlaceIntegration.getChannelFacilityRef()).method(HttpMethod.GET).headers(this.getDefaultHeaders());
        if (call.hasErrors()) {
            throw new RuntimeException(call.getError());
        }
    }

    public List<Order> getOrders(JSONObject orderJson) {
        String hboOrderNumber = String.valueOf(orderJson.get((Object)"Id"));
        List orders = new Select(new String[0]).from(new Class[]{Order.class}).where(new Expression(ModelReflector.instance(Order.class).getPool(), "REFERENCE", Operator.EQ, (Object[])new String[]{this.getOrderPrefix() + hboOrderNumber})).execute();
        return orders;
    }

    public List<OrderLine> getOrderLines(JSONObject orderLineJson) {
        String hboOrderLineNumber = String.valueOf(orderLineJson.get((Object)"Id"));
        List orderLines = new Select(new String[0]).from(new Class[]{OrderLine.class}).where(new Expression(ModelReflector.instance(OrderLine.class).getPool(), "CHANNEL_ORDER_LINE_REF", Operator.EQ, (Object[])new String[]{hboOrderLineNumber})).execute();
        return orderLines;
    }

    @Override
    public void cancel_line(JSONObject orderLineJson) {
        String hboOrderLineNumber = String.valueOf(orderLineJson.get((Object)"Id"));
        for (OrderLine line : this.getOrderLines(orderLineJson)) {
            line.cancel("User Cancellation");
        }
    }

    @Override
    public void confirm_delivery(JSONObject orderJson) {
        String hboOrderNumber = String.valueOf(orderJson.get((Object)"Id"));
        List orders = new Select(new String[0]).from(new Class[]{Order.class}).where(new Expression(ModelReflector.instance(Order.class).getPool(), "REFERENCE", Operator.EQ, (Object[])new String[]{this.getOrderPrefix() + hboOrderNumber})).execute();
        for (Order order : orders) {
            order.deliver();
        }
    }

    @Override
    public void book(JSONObject marketOrderJson) {
        if (!this.getOrders(marketOrderJson).isEmpty()) {
            return;
        }
        FormatHelper marketOrderHelper = FormatHelper.instance((Object)marketOrderJson);
        JSONObject juser = (JSONObject)marketOrderHelper.getElementAttribute("CreatorUser");
        marketOrderHelper.removeAttribute("CreatorUser");
        User user = this.getUser(juser);
        JSONObject jfacility = (JSONObject)marketOrderHelper.getElementAttribute("Facility");
        marketOrderHelper.removeElementAttribute("Facility");
        if (!ObjectUtil.equals((Object)jfacility.get((Object)"MerchantFacilityReference"), (Object)String.valueOf(this.marketPlaceIntegration.getFacilityId()))) {
            throw new RuntimeException(String.format("Facility mismatch (%s vs %d) for %s", jfacility.get((Object)"MerchantFacilityReference"), this.marketPlaceIntegration.getFacilityId(), this.marketPlaceIntegration.getName()));
        }
        Order order = (Order)Database.getTable(Order.class).newRecord();
        order.setReference(this.getOrderPrefix() + marketOrderHelper.getAttribute("Id"));
        order.setMarketPlaceIntegrationId(this.marketPlaceIntegration.getId());
        order.setShipByDate((Timestamp)order.getReflector().getJdbcTypeHelper().getTypeRef(Timestamp.class).getTypeConverter().valueOf(marketOrderHelper.getAttribute("ShipByDate")));
        order.setShipAfterDate((Timestamp)order.getReflector().getJdbcTypeHelper().getTypeRef(Timestamp.class).getTypeConverter().valueOf(marketOrderHelper.getAttribute("ShipAfterDate")));
        order.setProductPrice(new DoubleHolder(((Double)order.getReflector().getJdbcTypeHelper().getTypeRef(Double.class).getTypeConverter().valueOf(marketOrderHelper.getAttribute("ProductPrice"))).doubleValue(), 2).getHeldDouble().doubleValue());
        order.setProductSellingPrice(new DoubleHolder(((Double)order.getReflector().getJdbcTypeHelper().getTypeRef(Double.class).getTypeConverter().valueOf(marketOrderHelper.getAttribute("ProductSellingPrice"))).doubleValue(), 2).getHeldDouble().doubleValue());
        order.setShippingPrice(new DoubleHolder(((Double)order.getReflector().getJdbcTypeHelper().getTypeRef(Double.class).getTypeConverter().valueOf(marketOrderHelper.getAttribute("ShippingPrice"))).doubleValue(), 2).getHeldDouble().doubleValue());
        order.setShippingSellingPrice(new DoubleHolder(((Double)order.getReflector().getJdbcTypeHelper().getTypeRef(Double.class).getTypeConverter().valueOf(marketOrderHelper.getAttribute("ShippingSellingPrice"))).doubleValue(), 2).getHeldDouble().doubleValue());
        order.setPrice(new DoubleHolder(((Double)order.getReflector().getJdbcTypeHelper().getTypeRef(Double.class).getTypeConverter().valueOf(marketOrderHelper.getAttribute("Price"))).doubleValue(), 2).getHeldDouble().doubleValue());
        order.setSellingPrice(new DoubleHolder(((Double)order.getReflector().getJdbcTypeHelper().getTypeRef(Double.class).getTypeConverter().valueOf(marketOrderHelper.getAttribute("SellingPrice"))).doubleValue(), 2).getHeldDouble().doubleValue());
        order.setCGst(new DoubleHolder(((Double)order.getReflector().getJdbcTypeHelper().getTypeRef(Double.class).getTypeConverter().valueOf(marketOrderHelper.getAttribute("CGst"))).doubleValue(), 2).getHeldDouble().doubleValue());
        order.setSGst(new DoubleHolder(((Double)order.getReflector().getJdbcTypeHelper().getTypeRef(Double.class).getTypeConverter().valueOf(marketOrderHelper.getAttribute("SGst"))).doubleValue(), 2).getHeldDouble().doubleValue());
        order.setIGst(new DoubleHolder(((Double)order.getReflector().getJdbcTypeHelper().getTypeRef(Double.class).getTypeConverter().valueOf(marketOrderHelper.getAttribute("IGst"))).doubleValue(), 2).getHeldDouble().doubleValue());
        order.save();
        Company company = (Company)order.getCompany().getRawRecord().getAsProxy(Company.class);
        Facility defaultShippingFacility = this.marketPlaceIntegration.getFacility();
        Boolean shippingWithinSameState = null;
        for (String at : new String[]{"ST", "BT"}) {
            OrderAddress address = (OrderAddress)Database.getTable(OrderAddress.class).newRecord();
            address.setAddressType(at);
            Address.copy((Model)user, (Model)address);
            address.setFirstName(user.getFirstName());
            address.setLastName(user.getLastName());
            address.setOrderId(order.getId());
            address.save();
            if (shippingWithinSameState != null || !at.equals("ST")) continue;
            shippingWithinSameState = ObjectUtil.equals((Object)defaultShippingFacility.getStateId(), (Object)address.getStateId());
        }
        double defaultGSTPct = 18.0;
        Cache<String, Bucket> buckets = new Cache<String, Bucket>(){

            protected Bucket getValue(String fieldName) {
                return new Bucket();
            }
        };
        String[] LINE_FIELDS_TO_SYNC = new String[]{"PRODUCT_SELLING_PRICE", "PRODUCT_PRICE", "C_GST", "I_GST", "S_GST"};
        for (JSONObject orderLineElement : marketOrderHelper.getArrayElements("OrderLine")) {
            FormatHelper lineHelper = FormatHelper.instance((Object)orderLineElement);
            FormatHelper skuHelper = FormatHelper.instance((Object)((JSONObject)lineHelper.getElementAttribute("Sku")));
            String itemName = (String)((JSONObject)skuHelper.getElementAttribute("Item")).get((Object)"Name");
            String uomName = (String)((JSONObject)skuHelper.getElementAttribute("PackagingUOM")).get((Object)"Name");
            Sku sku = Sku.find(order.getCompanyId(), itemName, uomName);
            if (sku == null && ObjectUtil.equals((Object)"Each", (Object)uomName)) {
                sku = Sku.find(order.getCompanyId(), itemName);
            }
            if (sku == null) {
                throw new RuntimeException("Invalid sku in Market place :" + itemName + " - " + uomName);
            }
            OrderLine line = (OrderLine)Database.getTable(OrderLine.class).newRecord();
            line.setOrderId(order.getId());
            line.setChannelOrderLineRef((String)lineHelper.getAttribute("Id"));
            line.setSkuId(sku.getId());
            line.setOrderedQuantity((Double)line.getReflector().getJdbcTypeHelper().getTypeRef(Double.TYPE).getTypeConverter().valueOf(lineHelper.getAttribute("OrderedQuantity")));
            line.setMaxRetailPrice(new DoubleHolder(((Double)line.getReflector().getJdbcTypeHelper().getTypeRef(Double.TYPE).getTypeConverter().valueOf(lineHelper.getAttribute("MaxRetailPrice"))).doubleValue(), 2).getHeldDouble().doubleValue());
            line.setSellingPrice(new DoubleHolder(((Double)line.getReflector().getJdbcTypeHelper().getTypeRef(Double.TYPE).getTypeConverter().valueOf(lineHelper.getAttribute("SellingPrice"))).doubleValue(), 2).getHeldDouble().doubleValue());
            line.setPrice(new DoubleHolder(((Double)line.getReflector().getJdbcTypeHelper().getTypeRef(Double.TYPE).getTypeConverter().valueOf(lineHelper.getAttribute("Price"))).doubleValue(), 2).getHeldDouble().doubleValue());
            line.setCGst(new DoubleHolder(((Double)line.getReflector().getJdbcTypeHelper().getTypeRef(Double.TYPE).getTypeConverter().valueOf(lineHelper.getAttribute("CGst"))).doubleValue(), 2).getHeldDouble().doubleValue());
            line.setSGst(new DoubleHolder(((Double)line.getReflector().getJdbcTypeHelper().getTypeRef(Double.TYPE).getTypeConverter().valueOf(lineHelper.getAttribute("SGst"))).doubleValue(), 2).getHeldDouble().doubleValue());
            line.setIGst(new DoubleHolder(((Double)line.getReflector().getJdbcTypeHelper().getTypeRef(Double.TYPE).getTypeConverter().valueOf(lineHelper.getAttribute("IGst"))).doubleValue(), 2).getHeldDouble().doubleValue());
            line.setDiscountPercentage((Double)line.getReflector().getJdbcTypeHelper().getTypeRef(Double.TYPE).getTypeConverter().valueOf(lineHelper.getAttribute("DiscountPercentage")));
            line.setShipFromId(this.getFacilityId());
            for (String priceField : LINE_FIELDS_TO_SYNC) {
                ((Bucket)buckets.get((Object)priceField)).increment(((Double)line.getReflector().getJdbcTypeHelper().getTypeRef(Double.TYPE).getTypeConverter().valueOf(line.getReflector().get((Object)line, priceField))).doubleValue());
            }
            line.save();
        }
        if (shippingWithinSameState == null) {
            throw new RuntimeException("No Lines passed");
        }
        for (String priceField : LINE_FIELDS_TO_SYNC) {
            if (DoubleUtils.equals((double)((Bucket)buckets.get((Object)priceField)).doubleValue(), (double)((Double)order.getReflector().get((Object)order, priceField)), (int)2)) continue;
            throw new RuntimeException("Error, Price mismatch on " + order.getReference());
        }
        order.save();
    }

    private User getUser(JSONObject juser) {
        FormatHelper userHelper = FormatHelper.instance((Object)juser);
        userHelper.setAttribute("Name", this.getUserPrefix() + userHelper.getAttribute("Name"));
        userHelper.setAttribute("AutoGenerated", "Y");
        this.removeId(juser);
        User user = (User)ModelIOFactory.getReader(User.class, JSONObject.class).read((Object)juser);
        if (user.getRawRecord().isNewRecord()) {
            user.setNotificationEnabled(false);
        }
        user.setCityId(user.getPinCode().getCityId());
        user.setStateId(user.getPinCode().getStateId());
        user.save();
        return user;
    }

    private void removeId(Object o) {
        block4: {
            block3: {
                if (!(o instanceof JSONObject)) break block3;
                HashSet names = new HashSet(((JSONObject)o).keySet());
                for (Object name : names) {
                    if ("Id".equals(name) || "Company".equals(name) || "City".equals(name) || "State".equals(name)) {
                        ((JSONObject)o).remove(name);
                        continue;
                    }
                    Object value = ((JSONObject)o).get(name);
                    if (!(value instanceof JSONObject) && !(value instanceof JSONArray)) continue;
                    this.removeId(value);
                }
                break block4;
            }
            if (!(o instanceof JSONArray)) break block4;
            JSONArray arr = (JSONArray)o;
            for (int i = 0; i < arr.size(); ++i) {
                this.removeId(arr.get(i));
            }
        }
    }

    public static class BookOrder
    implements Task {
        JSONObject marketjson = null;
        MarketPlaceIntegration integration;

        public BookOrder(JSONObject marketJson, MarketPlaceIntegration integration) {
            this.marketjson = marketJson;
            this.integration = integration;
        }

        public BookOrder() {
        }

        public void execute() {
            HumBhiOnline.getInstance(this.integration).book(this.marketjson);
        }
    }
}

