/*
 * Decompiled with CFR 0.152.
 */
package in.succinct.plugins.ecommerce.integration.unicommerce;

import com.venky.cache.Cache;
import com.venky.core.collections.SequenceSet;
import com.venky.core.date.DateUtils;
import com.venky.core.io.ByteArrayInputStream;
import com.venky.core.util.Bucket;
import com.venky.core.util.ObjectUtil;
import com.venky.swf.db.Database;
import com.venky.swf.db.annotations.column.ui.mimes.MimeType;
import com.venky.swf.integration.api.Call;
import com.venky.swf.integration.api.InputFormat;
import com.venky.swf.plugins.collab.db.model.config.City;
import com.venky.swf.plugins.collab.db.model.config.Country;
import com.venky.swf.plugins.collab.db.model.config.PinCode;
import com.venky.swf.plugins.collab.db.model.config.State;
import com.venky.swf.sql.Conjunction;
import com.venky.swf.sql.Expression;
import com.venky.swf.sql.Operator;
import com.venky.swf.sql.Select;
import in.succinct.plugins.ecommerce.db.model.catalog.ItemCategory;
import in.succinct.plugins.ecommerce.db.model.catalog.UnitOfMeasureConversionTable;
import in.succinct.plugins.ecommerce.db.model.inventory.Inventory;
import in.succinct.plugins.ecommerce.db.model.inventory.InventoryCalculator;
import in.succinct.plugins.ecommerce.db.model.inventory.Sku;
import in.succinct.plugins.ecommerce.db.model.order.Order;
import in.succinct.plugins.ecommerce.db.model.order.OrderAddress;
import in.succinct.plugins.ecommerce.db.model.order.OrderAttribute;
import in.succinct.plugins.ecommerce.db.model.order.OrderLine;
import in.succinct.plugins.ecommerce.db.model.order.OrderPrint;
import in.succinct.plugins.ecommerce.db.model.participation.Facility;
import in.succinct.plugins.ecommerce.db.model.participation.MarketPlaceIntegration;
import in.succinct.plugins.ecommerce.integration.MarketPlace;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.json.simple.JSONArray;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;

public class UniCommerce
implements MarketPlace,
MarketPlace.WarehouseActionHandler,
MarketPlace.UserActionHandler {
    private static Map<Long, UniCommerce> instance = new Cache<Long, UniCommerce>(){

        protected UniCommerce getValue(Long marketPlaceIntegrationId) {
            return new UniCommerce(marketPlaceIntegrationId);
        }
    };
    MarketPlaceIntegration marketPlaceIntegration;
    Facility facility;

    private UniCommerce(Long marketPlaceIntegrationId) {
        this((MarketPlaceIntegration)Database.getTable(MarketPlaceIntegration.class).get(marketPlaceIntegrationId.longValue()));
    }

    private UniCommerce(MarketPlaceIntegration marketPlaceIntegration) {
        this.marketPlaceIntegration = marketPlaceIntegration;
        this.facility = marketPlaceIntegration.getFacility();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UniCommerce getInstance(MarketPlaceIntegration marketPlaceIntegration) {
        if (!instance.containsKey(marketPlaceIntegration.getId())) {
            Map<Long, UniCommerce> map = instance;
            synchronized (map) {
                if (!instance.containsKey(marketPlaceIntegration.getId())) {
                    instance.put(marketPlaceIntegration.getId(), new UniCommerce(marketPlaceIntegration));
                }
            }
        }
        return instance.get(marketPlaceIntegration.getId());
    }

    @Override
    public long getFacilityId() {
        return this.marketPlaceIntegration.getFacilityId();
    }

    @Override
    public String getOrderPrefix() {
        return "UC";
    }

    @Override
    public MarketPlace.WarehouseActionHandler getWarehouseActionHandler() {
        return this;
    }

    @Override
    public MarketPlace.UserActionHandler getUserActionHandler() {
        return this;
    }

    private String getBaseUrl() {
        return this.facility.getPreferredMarketPlaceIntegrations().get(0).getBaseUrl();
    }

    private String getPassword() {
        return this.facility.getPreferredMarketPlaceIntegrations().get(0).getPassword();
    }

    private String getUserName() {
        return this.facility.getPreferredMarketPlaceIntegrations().get(0).getUsername();
    }

    private String getClientId() {
        return this.facility.getPreferredMarketPlaceIntegrations().get(0).getClientId();
    }

    private String getAccessToken() {
        String url = String.format(this.getBaseUrl() + "/oauth/token?grant_type=password&client_id=%s&username=%s&password=%s", this.getClientId(), this.getUserName(), this.getPassword());
        JSONObject object = (JSONObject)new Call().url(url).getResponseAsJson();
        return String.format("%s %s", object.get((Object)"Token_Type"), object.get((Object)"Access_Token"));
    }

    private Map<String, String> getDefaultHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", MimeType.APPLICATION_JSON.toString());
        headers.put("Authorization", this.getAccessToken());
        return headers;
    }

    public void sync(Sku sku) {
        if (!sku.isPublished()) {
            return;
        }
        Map<String, String> headers = this.getDefaultHeaders();
        JSONObject input = new JSONObject();
        JSONObject itemType = new JSONObject();
        input.put((Object)"itemType", (Object)itemType);
        itemType.put((Object)"skuCode", (Object)sku.getSkuCode());
        itemType.put((Object)"name", (Object)sku.getName());
        itemType.put((Object)"description", (Object)sku.getShortDescription());
        itemType.put((Object)"length", (Object)UnitOfMeasureConversionTable.convert((double)sku.getLength(), "Length", sku.getLengthUOM().getName(), "Cms"));
        itemType.put((Object)"width", (Object)UnitOfMeasureConversionTable.convert((double)sku.getWidth(), "Length", sku.getWidthUOM().getName(), "Cms"));
        itemType.put((Object)"height", (Object)UnitOfMeasureConversionTable.convert((double)sku.getHeight(), "Length", sku.getHeightUOM().getName(), "Cms"));
        itemType.put((Object)"weight", (Object)UnitOfMeasureConversionTable.convert((double)sku.getWeight(), "Weight", sku.getWeightUOM().getName(), "Gms"));
        itemType.put((Object)"maxRetailPrice", (Object)sku.getSellingPrice());
        ItemCategory category = sku.getItem().getItemCategory("HSN");
        if (category != null) {
            itemType.put((Object)"hsnCode", (Object)sku.getItem().getItemCategory("HSN").getMasterItemCategoryValue().getAllowedValue());
        }
        itemType.put((Object)"imageUrl", (Object)sku.getSmallImageUrl());
        Call call = new Call().url(this.getBaseUrl(), "services/rest/v1/catalog/itemType/createOrEdit").headers(headers).inputFormat(InputFormat.JSON).input((Object)input);
        JSONObject object = this.execute(call);
    }

    public void syncInventory(Sku sku) {
        this.syncInventory(sku, this.getDefaultHeaders());
    }

    private void syncInventory(Sku sku, Map<String, String> headers) {
        if (!sku.isPublished()) {
            return;
        }
        InventoryCalculator calculator = new InventoryCalculator(sku, this.facility);
        double atp = calculator.getTotalInventory();
        double inventoryToUpdate = atp + this.getMarketDemand(sku, this.facility);
        JSONObject inventory = new JSONObject();
        JSONObject adjust = new JSONObject();
        inventory.put((Object)"inventoryAdjustment", (Object)adjust);
        adjust.put((Object)"itemSKU", (Object)sku.getSkuCode());
        adjust.put((Object)"quantity", (Object)inventoryToUpdate);
        adjust.put((Object)"shelfCode", (Object)"DEFAULT");
        adjust.put((Object)"inventoryType", (Object)"GOOD_INVENTORY");
        adjust.put((Object)"facilityCode", (Object)this.facility.getName());
        adjust.put((Object)"adjustmentType", (Object)"REPLACE");
        Call adjustCall = new Call().url(this.getBaseUrl(), "services/rest/v1/inventory/adjust");
        adjustCall.inputFormat(InputFormat.JSON).input((Object)inventory).headers(headers);
        JSONObject response = this.execute(adjustCall);
    }

    private double getUnicommerceInventory(Sku sku, Map<String, String> headers) {
        JSONObject input = new JSONObject();
        JSONArray skus = new JSONArray();
        input.put((Object)"itemTypeSKUS", (Object)skus);
        skus.add((Object)sku.getSkuCode());
        input.put((Object)"updatedSinceMinutes", (Object)2880);
        Call call = new Call().url(this.getBaseUrl(), "/services/rest/v1/inventory/inventorySnapshot/get").headers(headers).inputFormat(InputFormat.JSON).input((Object)input);
        if (call.hasErrors()) {
            throw new RuntimeException(call.getError());
        }
        JSONObject response = (JSONObject)call.getResponseAsJson();
        if (!((Boolean)sku.getReflector().getJdbcTypeHelper().getTypeRef(Boolean.class).getTypeConverter().valueOf(response.get((Object)"successful"))).booleanValue()) {
            throw new RuntimeException("Got " + response);
        }
        JSONArray snapshots = (JSONArray)response.get((Object)"inventorySnapshots");
        if (snapshots.size() == 0) {
            return 0.0;
        }
        Double quantity = (Double)sku.getReflector().getJdbcTypeHelper().getTypeRef(Double.TYPE).getTypeConverter().valueOf(((JSONObject)snapshots.get(0)).get((Object)"inventory"));
        return quantity;
    }

    private double getMarketDemand(Sku sku, Facility facility) {
        Select select = new Select(new String[0]).from(new Class[]{OrderLine.class});
        Expression where = new Expression(select.getPool(), Conjunction.AND);
        where.add(new Expression(select.getPool(), "SKU_ID", Operator.EQ, (Object[])new Long[]{sku.getId()}));
        where.add(new Expression(select.getPool(), "SHIP_FROM_ID", Operator.EQ, (Object[])new Long[]{facility.getId()}));
        select.where(where).add(" AND ORDERED_QUANTITY - CANCELLED_QUANTITY - SHIPPED_QUANTITY - RETURNED_QUANTITY > 0 AND EXISTS ( select 1 from orders where id = order_lines.order_id and reference like 'UC%' )");
        List lines = select.execute();
        Bucket demand = new Bucket();
        for (OrderLine line : lines) {
            demand.increment(line.getToShipQuantity());
        }
        return demand.doubleValue();
    }

    @Override
    public void sync(Inventory inventory) {
        this.syncInventory(inventory.getSku());
    }

    @Override
    public void pullOrders(Order lastOrder) {
        this.pullOrders(lastOrder == null ? new Timestamp(0L) : lastOrder.getCreatedAt());
    }

    @Override
    public void pack(Order order) {
        this.readyToShip(order);
    }

    @Override
    public void ship(Order order) {
        this.dispatch(order);
    }

    @Override
    public void deliver(Order order) {
    }

    public void pullOrders(Timestamp after) {
        Map<String, String> headers = this.getDefaultHeaders();
        JSONObject input = new JSONObject();
        String DATE_TIME_FORMAT_WITH_TZ_STR = "yyyy-MM-dd'T'HH:mm:ssZ";
        input.put((Object)"fromDate", (Object)DateUtils.getFormat((String)DATE_TIME_FORMAT_WITH_TZ_STR).format(after));
        JSONArray facilityCodes = new JSONArray();
        facilityCodes.add((Object)this.facility.getName());
        input.put((Object)"facilityCodes", (Object)facilityCodes);
        Call call = new Call().url(this.getBaseUrl(), "/services/rest/v1/oms/saleOrder/search").inputFormat(InputFormat.JSON).input((Object)input).headers(headers);
        JSONObject response = this.execute(call);
        JSONArray elements = (JSONArray)response.get((Object)"elements");
        ArrayList<String> orderNumbers = new ArrayList<String>();
        for (Object element : elements) {
            JSONObject jsonObject = (JSONObject)element;
            orderNumbers.add(String.valueOf(jsonObject.get((Object)"code")));
        }
        for (String orderNumber : orderNumbers) {
            this.pullOrder(orderNumber, headers);
        }
    }

    private void pullOrder(String orderNumber, Map<String, String> headers) {
        JSONObject input = new JSONObject();
        input.put((Object)"code", (Object)orderNumber);
        Call call = new Call().url(this.getBaseUrl(), "/services/rest/v1/oms/saleOrder/get").inputFormat(InputFormat.JSON).input((Object)input).headers(headers);
        JSONObject response = this.execute(call);
        String reference = "UC-" + orderNumber;
        Select select = new Select(new String[0]).from(new Class[]{Order.class});
        List orders = select.where(new Expression(select.getPool(), "REFERENCE", Operator.EQ, (Object[])new String[]{reference})).execute();
        JSONObject saleOrder = (JSONObject)response.get((Object)"saleOrderDTO");
        if (!orders.isEmpty()) {
            if (orders.size() != 1) {
                throw new RuntimeException("Multiple orders found for reference " + reference);
            }
            Order order = (Order)orders.get(0);
            if (!ObjectUtil.equals((Object)order.getFulfillmentStatus(), (Object)"CANCELLED") && ObjectUtil.equals((Object)"CANCELLED", (Object)saleOrder.get((Object)"status"))) {
                order.cancel("", "Market Place");
            }
            return;
        }
        Order order = (Order)Database.getTable(Order.class).newRecord();
        order.setReference("UC-" + saleOrder.get((Object)"code"));
        order.setMarketPlaceIntegrationId(this.marketPlaceIntegration.getId());
        order.setCreatedAt(new Timestamp((Long)order.getReflector().getJdbcTypeHelper().getTypeRef(Long.class).getTypeConverter().valueOf(saleOrder.get((Object)"created"))));
        order.setUpdatedAt(new Timestamp((Long)order.getReflector().getJdbcTypeHelper().getTypeRef(Long.class).getTypeConverter().valueOf(saleOrder.get((Object)"updated"))));
        order.setPreferredCarrierName("MarketPlace");
        order.save();
        JSONObject billingAddress = (JSONObject)saleOrder.get((Object)"billingAddress");
        OrderAddress billTo = (OrderAddress)Database.getTable(OrderAddress.class).newRecord();
        billTo.setOrderId(order.getId());
        billTo.setAddressType("BT");
        billTo.setFirstName((String)billTo.getReflector().getJdbcTypeHelper().getTypeRef(String.class).getTypeConverter().valueOf(billingAddress.get((Object)"name")));
        billTo.setAddressLine1((String)billTo.getReflector().getJdbcTypeHelper().getTypeRef(String.class).getTypeConverter().valueOf(billingAddress.get((Object)"addressLine1")));
        billTo.setAddressLine2((String)billTo.getReflector().getJdbcTypeHelper().getTypeRef(String.class).getTypeConverter().valueOf(billingAddress.get((Object)"addressLine2")));
        billTo.setCountryId(Country.findByISO((String)((String)billTo.getReflector().getJdbcTypeHelper().getTypeRef(String.class).getTypeConverter().valueOf(billingAddress.get((Object)"country")))).getId());
        billTo.setStateId(State.findByCountryAndCode((Long)billTo.getCountryId(), (String)((String)billTo.getReflector().getJdbcTypeHelper().getTypeRef(String.class).getTypeConverter().valueOf(billingAddress.get((Object)"state")))).getId());
        billTo.setCityId(City.findByStateAndName((long)billTo.getStateId(), (String)((String)billTo.getReflector().getJdbcTypeHelper().getTypeRef(String.class).getTypeConverter().valueOf(billingAddress.get((Object)"city")))).getId());
        billTo.setPinCodeId(PinCode.find((String)((String)billTo.getReflector().getJdbcTypeHelper().getTypeRef(String.class).getTypeConverter().valueOf(billingAddress.get((Object)"pincode")))).getId());
        billTo.setPhoneNumber((String)billTo.getReflector().getJdbcTypeHelper().getTypeRef(String.class).getTypeConverter().valueOf(billingAddress.get((Object)"phone")));
        billTo.setEmail((String)billTo.getReflector().getJdbcTypeHelper().getTypeRef(String.class).getTypeConverter().valueOf(billingAddress.get((Object)"email")));
        OrderAddress shipTo = (OrderAddress)Database.getTable(OrderAddress.class).newRecord();
        shipTo.getRawRecord().load(billTo.getRawRecord());
        shipTo.setAddressType("ST");
        billTo.save();
        shipTo.save();
        JSONArray saleOrderItems = (JSONArray)saleOrder.get((Object)"saleOrderItems");
        for (Object o : saleOrderItems) {
            JSONObject saleOrderItem = (JSONObject)o;
            OrderLine line = (OrderLine)Database.getTable(OrderLine.class).newRecord();
            line.setOrderId(order.getId());
            if (!ObjectUtil.equals((Object)saleOrderItem.get((Object)"facilityCode"), (Object)this.facility.getName())) {
                throw new RuntimeException("Some thing went wrong in filtering for specific facility from Unicommerce! " + this.facility.getName());
            }
            line.setShipFromId(this.facility.getId());
            Sku sku = Sku.find(this.facility.getCompanyId(), (String)line.getReflector().getJdbcTypeHelper().getTypeRef(String.class).getTypeConverter().valueOf((Object)"itemSku"));
            line.setSkuId(sku.getId());
            line.setOrderedQuantity(1.0);
            line.setMaxRetailPrice(sku.getSellingPrice());
            line.setSellingPrice((Double)line.getReflector().getJdbcTypeHelper().getTypeRef(Double.class).getTypeConverter().valueOf((Object)"sellingPrice"));
            line.setShipTogetherCode((String)line.getReflector().getJdbcTypeHelper().getTypeRef(String.class).getTypeConverter().valueOf((Object)"shippingPackageCode"));
            line.setPrice(line.getSellingPrice() / (1.0 + sku.getTaxRate() / 100.0));
            double tax = sku.getTaxRate() / 100.0 * line.getPrice();
            if (ObjectUtil.equals((Object)shipTo.getStateId(), (Object)this.facility.getStateId())) {
                line.setIGst(0.0);
                line.setCGst(tax / 2.0);
                line.setSGst(tax / 2.0);
            } else {
                line.setIGst(tax);
                line.setCGst(0.0);
                line.setSGst(0.0);
            }
            line.setDiscountPercentage((line.getMaxRetailPrice() - line.getSellingPrice()) * 100.0 / line.getMaxRetailPrice());
            line.save();
        }
    }

    public void readyToShip(Order order) {
        if (ObjectUtil.equals((Object)order.getFulfillmentStatus(), (Object)"PACKED") || ObjectUtil.equals((Object)order.getFulfillmentStatus(), (Object)"MANIFESTED")) {
            SequenceSet packageCodes = new SequenceSet();
            for (OrderLine orderLine : order.getOrderLines()) {
                if (ObjectUtil.isVoid((Object)orderLine.getShipTogetherCode()) || !(orderLine.getToShipQuantity() > 0.0) || orderLine.getToPackQuantity() != 0.0) continue;
                packageCodes.add(orderLine.getShipTogetherCode());
            }
            Map<String, String> headers = this.getDefaultHeaders();
            Map<String, OrderAttribute> map = order.getAttributeMap();
            for (String packageCode : packageCodes) {
                JSONObject input = new JSONObject();
                input.put((Object)"shippingPackageCode", (Object)packageCode);
                Call call = new Call().url(this.getBaseUrl(), "/services/rest/v1/oms/shippingPackage/createInvoiceAndAllocateShippingProvider").inputFormat(InputFormat.JSON).headers(headers).input((Object)input);
                JSONObject response = this.execute(call);
                map.get("InvoiceCode-" + packageCode).setValue((String)order.getReflector().getJdbcTypeHelper().getTypeRef(String.class).getTypeConverter().valueOf(response.get((Object)"invoiceCode")));
                map.get("ShippingProviderCode-" + packageCode).setValue((String)order.getReflector().getJdbcTypeHelper().getTypeRef(String.class).getTypeConverter().valueOf(response.get((Object)"shippingProviderCode")));
                map.get("TrackingNumber-" + packageCode).setValue((String)order.getReflector().getJdbcTypeHelper().getTypeRef(String.class).getTypeConverter().valueOf(response.get((Object)"trackingNumber")));
                map.get("ShippingLabelLink-" + packageCode).setValue((String)order.getReflector().getJdbcTypeHelper().getTypeRef(String.class).getTypeConverter().valueOf(response.get((Object)"shippingLabelLink")));
                this.downloadPackList(map.get("ShippingLabelLink-" + packageCode).getValue(), order, headers);
                Call invoiceDetail = new Call().url(this.getBaseUrl(), "/services/rest/v1/invoice/details/get").inputFormat(InputFormat.JSON).input((Object)input).headers(headers);
                JSONObject jsonInvoice = this.execute(invoiceDetail);
                String trackingNumber = (String)jsonInvoice.get((Object)"trackingNumber");
                map.get("TrackingNumber-" + packageCode).setValue(trackingNumber);
            }
            order.saveAttributeMap(map);
        }
    }

    private void downloadPackList(String imageLink, Order order, Map<String, String> headers) {
        Optional<OrderPrint> opPrint = order.getOrderPrints().stream().filter(p -> ObjectUtil.equals((Object)p.getDocumentType(), (Object)"PACK_SLIP")).findFirst();
        if (opPrint.isPresent()) {
            return;
        }
        if (!((String)imageLink).startsWith("http")) {
            imageLink = this.getBaseUrl() + "/" + (String)imageLink;
        }
        Call call = new Call().url((String)imageLink).headers(headers);
        ByteArrayInputStream byteArrayInputStream = (ByteArrayInputStream)call.getResponseStream();
        OrderPrint print = (OrderPrint)Database.getTable(OrderPrint.class).newRecord();
        print.setOrderId(order.getId());
        print.setDocumentType("PACK_SLIP");
        print.setImageContentName("Carton-" + order.getId() + ".pdf");
        print.setImageContentType(MimeType.APPLICATION_PDF.toString());
        print.setImageContentSize(byteArrayInputStream.available());
        print.setImage((InputStream)byteArrayInputStream);
        print.save();
    }

    private <T extends JSONAware> JSONObject execute(Call<T> call) {
        if (call.hasErrors()) {
            throw new RuntimeException(call.getError());
        }
        JSONObject response = (JSONObject)call.getResponseAsJson();
        if (!((Boolean)Database.getJdbcTypeHelper((String)"").getTypeRef(Boolean.class).getTypeConverter().valueOf(response.get((Object)"successful"))).booleanValue()) {
            throw new RuntimeException("Got " + response);
        }
        return response;
    }

    public void dispatch(Order order) {
        if (!ObjectUtil.equals((Object)order.getFulfillmentStatus(), (Object)"SHIPPED")) {
            return;
        }
        SequenceSet packageCodes = new SequenceSet();
        for (OrderLine orderLine : order.getOrderLines()) {
            if (ObjectUtil.isVoid((Object)orderLine.getShipTogetherCode()) || !(orderLine.getShippedQuantity() > 0.0)) continue;
            packageCodes.add(orderLine.getShipTogetherCode());
        }
        Map<String, String> headers = this.getDefaultHeaders();
        for (String packageCode : packageCodes) {
            JSONObject input = new JSONObject();
            input.put((Object)"shippingPackageCode", (Object)packageCode);
            Call call = new Call().url(this.getBaseUrl(), "/services/rest/v1/oms/shippingPackage/dispatch").inputFormat(InputFormat.JSON).headers(headers).input((Object)input);
            this.execute(call);
        }
    }

    private void downloadPackList(Order order, String packageCode, Map<String, String> headers) {
        Optional<OrderPrint> opPrint = order.getOrderPrints().stream().filter(p -> ObjectUtil.equals((Object)p.getDocumentType(), (Object)"PACK_SLIP")).findFirst();
        if (opPrint.isPresent()) {
            return;
        }
        JSONObject input = new JSONObject();
        input.put((Object)"shippingPackageCode", (Object)packageCode);
        Call call = new Call().url(this.getBaseUrl(), "/services/rest/v1/oms/shippingPackage/invoiceLabel").inputFormat(InputFormat.JSON).headers(headers).input((Object)input);
        JSONObject response = this.execute(call);
        String labelbase64 = (String)response.get((Object)"label");
        byte[] bytes = Base64.getDecoder().decode(labelbase64.getBytes(StandardCharsets.UTF_8));
        OrderPrint print = (OrderPrint)Database.getTable(OrderPrint.class).newRecord();
        print.setOrderId(order.getId());
        print.setDocumentType("PACK_SLIP");
        print.setImageContentName("Carton-" + packageCode + ".png");
        print.setImageContentType(MimeType.IMAGE_PNG.toString());
        print.setImageContentSize(bytes.length);
        print.setImage((InputStream)new ByteArrayInputStream(bytes));
        print.save();
    }

    @Override
    public void reject(OrderLine orderLine) {
    }

    @Override
    public void startCount() {
    }

    @Override
    public void book(JSONObject orderJson) {
    }

    @Override
    public void cancel_line(JSONObject orderLineJson) {
    }

    @Override
    public void confirm_delivery(JSONObject orderJson) {
    }
}

