/*
 * Decompiled with CFR 0.152.
 */
package com.venky.swf.plugins.mail.core;

import com.venky.swf.plugins.mail.core.Mailer;
import com.venky.swf.plugins.mail.core.MailerFactory;
import com.venky.swf.routing.Config;
import java.util.LinkedList;
import java.util.logging.Level;
import org.codemonkey.simplejavamail.Email;

public class AsyncMailer
extends Thread {
    private static AsyncMailer _mailer = null;
    private Mailer mailer = null;
    private LinkedList<Email> emails = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AsyncMailer instance() {
        if (_mailer != null) {
            return _mailer;
        }
        Class<AsyncMailer> clazz = AsyncMailer.class;
        synchronized (AsyncMailer.class) {
            if (_mailer == null) {
                _mailer = new AsyncMailer();
                _mailer.start();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return _mailer;
        }
    }

    private AsyncMailer() {
        this.mailer = MailerFactory.instance().getMailer(Config.instance().getProperty("swf.sendmail.protocol"));
        this.setDaemon(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEmail(Email email) {
        LinkedList<Email> linkedList = this.emails;
        synchronized (linkedList) {
            this.emails.add(email);
            this.emails.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Email next() {
        LinkedList<Email> linkedList = this.emails;
        synchronized (linkedList) {
            this.waitIfQueueIsEmpty();
            return this.emails.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitIfQueueIsEmpty() {
        LinkedList<Email> linkedList = this.emails;
        synchronized (linkedList) {
            while (this.emails.isEmpty()) {
                try {
                    this.emails.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    @Override
    public void run() {
        Email email = null;
        while ((email = this.next()) != null) {
            try {
                if (this.mailer != null) {
                    this.mailer.sendMail(email);
                    continue;
                }
                Config.instance().getLogger(this.getClass().getName()).log(Level.WARNING, "Could not send mail. Mailer nor configured for \"swf.sendmail.protocol\"");
            }
            catch (Exception ex) {
                Config.instance().getLogger(this.getClass().getName()).log(Level.WARNING, "Could not send mail", (Throwable)ex);
            }
        }
    }
}

