/*
 * Decompiled with CFR 0.152.
 */
package com.venky.swf.plugins.mail.core;

import com.venky.core.io.ByteArrayInputStream;
import com.venky.core.io.StringReader;
import com.venky.core.util.ObjectUtil;
import com.venky.swf.db.Database;
import com.venky.swf.db.annotations.column.ui.mimes.MimeType;
import com.venky.swf.db.model.Model;
import com.venky.swf.db.model.UserEmail;
import com.venky.swf.db.model.reflection.ModelReflector;
import com.venky.swf.plugins.attachment.db.model.Attachment;
import com.venky.swf.plugins.background.core.Task;
import com.venky.swf.plugins.mail.core.AsyncMailer;
import com.venky.swf.plugins.mail.db.model.Mail;
import com.venky.swf.plugins.mail.db.model.MailAttachment;
import com.venky.swf.plugins.mail.db.model.User;
import com.venky.swf.pm.DataSecurityFilter;
import com.venky.swf.routing.Config;
import com.venky.swf.sql.Expression;
import com.venky.swf.sql.Operator;
import com.venky.swf.sql.Select;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.mail.Message;
import org.codemonkey.simplejavamail.Email;

public class MailerTask
implements Task {
    private static final long serialVersionUID = 8083486775891668308L;
    long toUserId;
    String toEmail;
    String subject;
    String text;
    boolean isHtml = false;
    List<Long> cc;
    List<Long> bcc;
    List<AttachedElement> attachedElements;

    @Deprecated
    public MailerTask() {
    }

    public MailerTask(User to, String subject, String text) {
        this(to, null, subject, text);
    }

    public MailerTask(User to, String toEmail, String subject, String text) {
        this(to, toEmail, subject, text, null, null, null);
    }

    public MailerTask(User to, String toEmail, String subject, String text, List<User> cc, List<User> bcc, List<AttachedElement> attachedElements) {
        String trim;
        int len;
        this.toUserId = to.getId();
        this.toEmail = toEmail;
        this.subject = subject;
        this.text = text;
        if (!ObjectUtil.isVoid((Object)text) && (len = (trim = text.trim()).length()) > 5) {
            boolean bl = this.isHtml = trim.substring(0, 5).equalsIgnoreCase("<html") || len > 14 && trim.substring(0, 14).equalsIgnoreCase("<!DOCTYPE html");
        }
        if (cc != null) {
            this.cc = DataSecurityFilter.getIds(cc);
        }
        if (bcc != null) {
            this.bcc = DataSecurityFilter.getIds(bcc);
        }
        if (attachedElements != null) {
            this.attachedElements = new ArrayList<AttachedElement>(attachedElements);
        }
    }

    public void execute() {
        User to = (User)Database.getTable(User.class).get(this.toUserId);
        if (to == null) {
            return;
        }
        ArrayList cc = this.cc == null ? new ArrayList() : new Select(new String[0]).from(new Class[]{User.class}).where(new Expression(ModelReflector.instance(User.class).getPool(), "ID", Operator.IN, this.cc.toArray())).execute();
        ArrayList bcc = this.bcc == null ? new ArrayList() : new Select(new String[0]).from(new Class[]{User.class}).where(new Expression(ModelReflector.instance(User.class).getPool(), "ID", Operator.IN, this.bcc.toArray())).execute();
        HashMap<Message.RecipientType, List<User>> map = new HashMap<Message.RecipientType, List<User>>();
        map.put(Message.RecipientType.TO, Collections.singletonList(to));
        map.put(Message.RecipientType.CC, cc);
        map.put(Message.RecipientType.BCC, bcc);
        List emails = to.getUserEmails();
        if (!ObjectUtil.isVoid((Object)this.toEmail)) {
            emails = emails.stream().filter(e -> ObjectUtil.equals((Object)e.getEmail(), (Object)this.toEmail)).collect(Collectors.toList());
        }
        if (emails.isEmpty()) {
            throw new RuntimeException("No toEmail available for " + to.getName());
        }
        String emailId = Config.instance().getProperty("swf.sendmail.user");
        String userName = Config.instance().getProperty("swf.sendmail.user.name");
        if (ObjectUtil.isVoid((Object)emailId)) {
            throw new RuntimeException("Plugin not configured :swf.sendmail.user");
        }
        Email email = new Email();
        email.setFromAddress(userName, emailId);
        email.setSubject(this.subject);
        StringBuilder emailString = new StringBuilder();
        for (Message.RecipientType type : map.keySet()) {
            List users = (List)map.get(type);
            if (users.isEmpty()) continue;
            emailString.append(type.toString()).append(": ");
            for (User user : users) {
                for (UserEmail useremail : user.getUserEmails()) {
                    email.addRecipient(useremail.getAlias() + "(" + useremail.getEmail() + ")", useremail.getEmail(), type);
                    emailString.append(useremail.getEmail()).append(";");
                }
            }
        }
        if (this.isHtml) {
            email.setTextHTML(this.text);
        } else {
            email.setText(this.text);
        }
        Mail mail = (Mail)Database.getTable(Mail.class).newRecord();
        mail.setUserId(this.toUserId);
        mail.setEmail(emailString.toString());
        mail.setSubject(this.subject);
        mail.setBody((Reader)new StringReader(this.text));
        mail.save();
        if (this.attachedElements != null && !this.attachedElements.isEmpty()) {
            for (AttachedElement element : this.attachedElements) {
                email.addAttachment(element.name, element.bytes, element.mimeType.toString());
                MailAttachment mailAttachment = (MailAttachment)Database.getTable(MailAttachment.class).newRecord();
                mailAttachment.setMailId(mail.getId());
                Attachment attachment = Attachment.find((String)element.name);
                if (attachment == null) {
                    attachment = (Attachment)Database.getTable(Attachment.class).newRecord();
                    attachment.setAttachment((InputStream)new ByteArrayInputStream(element.bytes));
                    attachment.setAttachmentContentName(element.name);
                    attachment.setAttachmentContentSize(element.bytes.length);
                    attachment.setAttachmentContentType(element.mimeType.toString());
                    attachment.save();
                }
                mailAttachment.setAttachmentId(attachment.getId());
                mailAttachment = (MailAttachment)Database.getTable(MailAttachment.class).getRefreshed((Model)mailAttachment);
                mailAttachment.save();
            }
        }
        AsyncMailer.instance().addEmail(email);
    }

    public static class AttachedElement
    implements Serializable {
        byte[] bytes;
        String name;
        MimeType mimeType;

        public AttachedElement() {
        }

        public AttachedElement(MimeType mimeType, String name, byte[] bytes) {
            this.bytes = bytes;
            this.name = name;
            this.mimeType = mimeType;
        }
    }
}

