/*
 * Decompiled with CFR 0.152.
 */
package com.github.rollingmetrics.dropwizard.adapter;

import com.codahale.metrics.Snapshot;
import com.github.rollingmetrics.histogram.hdr.RollingSnapshot;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class RollingHdrHistogramSnapshotAdapter
extends Snapshot {
    private final RollingSnapshot target;

    public RollingHdrHistogramSnapshotAdapter(RollingSnapshot target) {
        this.target = Objects.requireNonNull(target);
    }

    public double getValue(double quantile) {
        return this.target.getValue(quantile);
    }

    public long[] getValues() {
        return this.target.getValues();
    }

    public int size() {
        return this.target.size();
    }

    public long getMax() {
        return this.target.getMax();
    }

    public double getMean() {
        return this.target.getMean();
    }

    public long getMin() {
        return this.target.getMin();
    }

    public double getStdDev() {
        return this.target.getStdDev();
    }

    public void dump(OutputStream output) {
        try (PrintWriter p = new PrintWriter(new OutputStreamWriter(output, StandardCharsets.UTF_8));){
            for (long value : this.getValues()) {
                p.printf("%f%n", value);
            }
        }
    }
}

