/*
 * Decompiled with CFR 0.152.
 */
package com.github.vladislavsevruk.generator.java;

import com.github.vladislavsevruk.generator.java.comparator.FieldModifierComparator;
import com.github.vladislavsevruk.generator.java.config.JavaClassGeneratorConfig;
import com.github.vladislavsevruk.generator.java.provider.JavaClassContentGeneratorProvider;
import com.github.vladislavsevruk.generator.java.type.SchemaObject;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class JavaClassContentGenerator {
    private final JavaClassContentGeneratorProvider classContentGeneratorProvider;
    private final Comparator<String> fieldModifierComparator;

    public JavaClassContentGenerator(JavaClassContentGeneratorProvider classContentGeneratorProvider) {
        this(classContentGeneratorProvider, new FieldModifierComparator());
    }

    public JavaClassContentGenerator(JavaClassContentGeneratorProvider classContentGeneratorProvider, Comparator<String> fieldModifierComparator) {
        this.classContentGeneratorProvider = classContentGeneratorProvider;
        this.fieldModifierComparator = fieldModifierComparator;
    }

    public String generate(JavaClassGeneratorConfig config, SchemaObject schemaObject) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("// generated by com.github.vladislavsevruk:java-class-generator\n");
        stringBuilder.append(this.classContentGeneratorProvider.getPackageGenerator().generate(config, schemaObject));
        this.appendImports(stringBuilder, config, schemaObject);
        stringBuilder.append(this.classContentGeneratorProvider.getClassDeclarationGenerator().generate(config, schemaObject));
        this.appendFields(stringBuilder, config, schemaObject);
        this.classContentGeneratorProvider.getConstructorGenerators().forEach(generator -> stringBuilder.append(generator.generate(config, schemaObject)));
        this.classContentGeneratorProvider.getMethodGenerators().forEach(generator -> stringBuilder.append(generator.generate(config, schemaObject)));
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    private void appendFields(StringBuilder stringBuilder, JavaClassGeneratorConfig config, SchemaObject schemaObject) {
        List<String> fields = this.classContentGeneratorProvider.getFieldGenerators().stream().map(generator -> generator.generate(config, schemaObject)).filter(values -> !values.isEmpty()).flatMap(Collection::stream).sorted((f1, f2) -> config.isSortFieldsByModifiers() ? this.fieldModifierComparator.compare((String)f1, (String)f2) : 0).collect(Collectors.toList());
        if (!fields.isEmpty() && !config.isAddEmptyLineBetweenFields()) {
            stringBuilder.append("\n");
        }
        fields.forEach(stringBuilder::append);
    }

    private void appendImports(StringBuilder stringBuilder, JavaClassGeneratorConfig config, SchemaObject schemaObject) {
        List imports = this.classContentGeneratorProvider.getImportGenerators().stream().flatMap(generator -> generator.generate(config, schemaObject).stream()).distinct().sorted(String::compareTo).collect(Collectors.toList());
        if (!imports.isEmpty()) {
            stringBuilder.append("\n");
        }
        String prevImportStatement = null;
        for (String importStatement : imports) {
            if (prevImportStatement != null && this.isDomainDiffers(prevImportStatement, importStatement)) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(importStatement);
            prevImportStatement = importStatement;
        }
    }

    private String getDomain(String value) {
        int startIndex = value.indexOf("import") + "import".length();
        String className = value.substring(startIndex).trim();
        return className.substring(0, className.indexOf(46));
    }

    private boolean isDomainDiffers(String prevImportStatement, String importStatement) {
        return !this.getDomain(prevImportStatement).equals(this.getDomain(importStatement));
    }
}

