/*
 * Decompiled with CFR 0.152.
 */
package com.github.vladislavsevruk.generator.java;

import com.github.vladislavsevruk.generator.java.JavaClassContentGenerator;
import com.github.vladislavsevruk.generator.java.config.JavaClassGeneratorConfig;
import com.github.vladislavsevruk.generator.java.context.ClassGenerationContextManager;
import com.github.vladislavsevruk.generator.java.picker.ClassContentGeneratorPicker;
import com.github.vladislavsevruk.generator.java.provider.JavaClassContentGeneratorProvider;
import com.github.vladislavsevruk.generator.java.storage.SchemaObjectStorage;
import com.github.vladislavsevruk.generator.java.type.SchemaObject;
import com.github.vladislavsevruk.generator.java.util.FileUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JavaClassGenerator {
    private static final Logger logger = LogManager.getLogger(JavaClassGenerator.class);
    private ClassContentGeneratorPicker classContentGeneratorPicker;

    public JavaClassGenerator() {
        this(ClassGenerationContextManager.getContext().getClassContentGeneratorPicker());
    }

    public JavaClassGenerator(ClassContentGeneratorPicker classContentGeneratorPicker) {
        this.classContentGeneratorPicker = classContentGeneratorPicker;
    }

    public void generateJavaClass(JavaClassGeneratorConfig config, SchemaObject schemaObject) {
        FileUtil.recursiveMkdir(config.getPathToTargetFolder());
        this.generateJavaClassFile(config, schemaObject);
    }

    public void generateJavaClasses(JavaClassGeneratorConfig config, SchemaObjectStorage storage) {
        FileUtil.recursiveMkdir(config.getPathToTargetFolder());
        storage.getAllObjects().forEach(object -> this.generateJavaClassFile(config, (SchemaObject)object));
    }

    private void generateJavaClassFile(JavaClassGeneratorConfig config, SchemaObject schemaObject) {
        JavaClassContentGeneratorProvider classContentGeneratorProvider;
        String javaClassContent;
        String className = schemaObject.getName();
        String filePath = String.format("%s%s.java", FileUtil.addPathSeparator(config.getPathToTargetFolder()), className);
        String generatedFilePath = FileUtil.writeToNewFile(filePath, javaClassContent = new JavaClassContentGenerator(classContentGeneratorProvider = this.classContentGeneratorPicker.pickClassContentGeneratorProvider(schemaObject)).generate(config, schemaObject));
        if (generatedFilePath != null) {
            logger.info(() -> "Generated class: " + generatedFilePath);
        } else {
            logger.warn(() -> "Cannot generate: " + schemaObject.getName());
        }
    }
}

