/*
 * Decompiled with CFR 0.152.
 */
package com.github.vladislavsevruk.generator.java.comparator;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class FieldModifierComparator
implements Comparator<String> {
    private static final Pattern FIELD_MODIFIERS_PATTERN = Pattern.compile("(private|protected|public|static|final|volatile|transient)\\s+");
    private static final List<Predicate<Integer>> FIELD_MODIFIERS_PREDICATES = Arrays.asList(Modifier::isPublic, Modifier::isProtected, mod -> !Modifier.isPrivate(mod), ((Predicate<Integer>)Modifier::isStatic).and(Modifier::isFinal), Modifier::isStatic);

    @Override
    public int compare(String field1, String field2) {
        int field1Modifiers = this.getFieldModifiers(field1);
        int field2Modifiers = this.getFieldModifiers(field2);
        for (Predicate<Integer> fieldModifierPredicate : FIELD_MODIFIERS_PREDICATES) {
            int result = this.compareByPredicate(fieldModifierPredicate, field1Modifiers, field2Modifiers);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    private <T> int compareByPredicate(Predicate<T> predicate, T val1, T val2) {
        boolean val1Result = predicate.test(val1);
        if (val1Result != predicate.test(val2)) {
            return val1Result ? -1 : 1;
        }
        return 0;
    }

    private int getFieldModifiers(String field) {
        Matcher matcher = FIELD_MODIFIERS_PATTERN.matcher(field);
        matcher.region(0, field.indexOf(59));
        int i = 5;
        int modifiers = 0;
        while (matcher.find() && i-- > 0) {
            modifiers |= this.pickModifier(matcher.group(1));
        }
        return modifiers;
    }

    private int pickModifier(String modifier) {
        switch (modifier) {
            case "private": {
                return 2;
            }
            case "protected": {
                return 4;
            }
            case "public": {
                return 1;
            }
            case "static": {
                return 8;
            }
            case "final": {
                return 16;
            }
            case "volatile": {
                return 64;
            }
            case "transient": {
                return 128;
            }
        }
        return 0;
    }
}

