/*
 * Decompiled with CFR 0.152.
 */
package com.github.vladislavsevruk.generator.java.config;

import com.github.vladislavsevruk.generator.java.config.JavaClassGeneratorConfig;
import com.github.vladislavsevruk.generator.java.constant.Indent;
import com.github.vladislavsevruk.generator.java.util.DefaultValueUtil;
import java.io.File;

public class JavaClassGeneratorConfigBuilder {
    private boolean addEmptyLineBetweenFields = true;
    private boolean addJacksonAnnotations = false;
    private String pathToTargetFolder;
    private boolean sortFieldsByModifiers = true;
    private Indent useIndent;
    private boolean useLombokAnnotations = true;

    JavaClassGeneratorConfigBuilder() {
    }

    public JavaClassGeneratorConfig build() {
        this.pathToTargetFolder = DefaultValueUtil.orDefault(this.pathToTargetFolder, this.getDefaultTargetFolder());
        this.useIndent = DefaultValueUtil.orDefault(this.useIndent, Indent.SPACES_4);
        return new JavaClassGeneratorConfig(this.addEmptyLineBetweenFields, this.addJacksonAnnotations, this.useIndent, this.pathToTargetFolder, this.sortFieldsByModifiers, this.useLombokAnnotations);
    }

    private String getDefaultTargetFolder() {
        String dirPath = System.getProperty("user.dir");
        if (!dirPath.endsWith(File.separator)) {
            dirPath = dirPath + File.separator;
        }
        return dirPath + "model";
    }

    public JavaClassGeneratorConfigBuilder addEmptyLineBetweenFields(boolean addEmptyLineBetweenFields) {
        this.addEmptyLineBetweenFields = addEmptyLineBetweenFields;
        return this;
    }

    public JavaClassGeneratorConfigBuilder addJacksonAnnotations(boolean addJacksonAnnotations) {
        this.addJacksonAnnotations = addJacksonAnnotations;
        return this;
    }

    public JavaClassGeneratorConfigBuilder pathToTargetFolder(String pathToTargetFolder) {
        this.pathToTargetFolder = pathToTargetFolder;
        return this;
    }

    public JavaClassGeneratorConfigBuilder sortFieldsByModifiers(boolean sortFieldsByModifiers) {
        this.sortFieldsByModifiers = sortFieldsByModifiers;
        return this;
    }

    public JavaClassGeneratorConfigBuilder useIndent(Indent useIndent) {
        this.useIndent = useIndent;
        return this;
    }

    public JavaClassGeneratorConfigBuilder useLombokAnnotations(boolean useLombokAnnotations) {
        this.useLombokAnnotations = useLombokAnnotations;
        return this;
    }
}

