/*
 * Decompiled with CFR 0.152.
 */
package com.github.vladislavsevruk.generator.java.context;

import com.github.vladislavsevruk.generator.java.context.ClassGenerationContext;
import com.github.vladislavsevruk.generator.java.context.ClassGenerationModuleFactoryMethod;
import com.github.vladislavsevruk.generator.java.picker.ClassContentGeneratorPicker;
import com.github.vladislavsevruk.generator.java.picker.ClassContentGeneratorPickerImpl;
import com.github.vladislavsevruk.generator.java.storage.ClassContentGeneratorProviderStorage;
import com.github.vladislavsevruk.generator.java.storage.ClassContentGeneratorProviderStorageImpl;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class ClassGenerationContextImpl
implements ClassGenerationContext {
    private static final Logger logger = LogManager.getLogger(ClassGenerationContextImpl.class);
    private final ClassContentGeneratorPicker classContentGeneratorPicker;
    private final ClassContentGeneratorProviderStorage classContentGeneratorProviderStorage;

    ClassGenerationContextImpl(ClassGenerationModuleFactoryMethod<ClassContentGeneratorPicker> classContentGeneratorPickerFactoryMethod, ClassGenerationModuleFactoryMethod<ClassContentGeneratorProviderStorage> classContentGeneratorProviderStorageFactoryMethod) {
        this.classContentGeneratorProviderStorage = this.orDefault(classContentGeneratorProviderStorageFactoryMethod, context -> new ClassContentGeneratorProviderStorageImpl());
        logger.debug(() -> String.format("Using '%s' as class content generator provider storage.", this.classContentGeneratorProviderStorage.getClass().getName()));
        this.classContentGeneratorPicker = this.orDefault(classContentGeneratorPickerFactoryMethod, context -> new ClassContentGeneratorPickerImpl(this.classContentGeneratorProviderStorage));
        logger.debug(() -> String.format("Using '%s' as class content generator picker.", this.classContentGeneratorPicker.getClass().getName()));
    }

    private <T> T orDefault(ClassGenerationModuleFactoryMethod<T> factoryMethod, ClassGenerationModuleFactoryMethod<T> defaultFactoryMethod) {
        T module;
        if (factoryMethod != null && (module = factoryMethod.get(this)) != null) {
            return module;
        }
        return defaultFactoryMethod.get(this);
    }

    @Override
    public ClassContentGeneratorPicker getClassContentGeneratorPicker() {
        return this.classContentGeneratorPicker;
    }

    @Override
    public ClassContentGeneratorProviderStorage getClassContentGeneratorProviderStorage() {
        return this.classContentGeneratorProviderStorage;
    }

    public String toString() {
        return "ClassGenerationContextImpl(classContentGeneratorPicker=" + this.getClassContentGeneratorPicker() + ", classContentGeneratorProviderStorage=" + this.getClassContentGeneratorProviderStorage() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassGenerationContextImpl)) {
            return false;
        }
        ClassGenerationContextImpl other = (ClassGenerationContextImpl)o;
        ClassContentGeneratorPicker this$classContentGeneratorPicker = this.getClassContentGeneratorPicker();
        ClassContentGeneratorPicker other$classContentGeneratorPicker = other.getClassContentGeneratorPicker();
        if (this$classContentGeneratorPicker == null ? other$classContentGeneratorPicker != null : !this$classContentGeneratorPicker.equals(other$classContentGeneratorPicker)) {
            return false;
        }
        ClassContentGeneratorProviderStorage this$classContentGeneratorProviderStorage = this.getClassContentGeneratorProviderStorage();
        ClassContentGeneratorProviderStorage other$classContentGeneratorProviderStorage = other.getClassContentGeneratorProviderStorage();
        return !(this$classContentGeneratorProviderStorage == null ? other$classContentGeneratorProviderStorage != null : !this$classContentGeneratorProviderStorage.equals(other$classContentGeneratorProviderStorage));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ClassContentGeneratorPicker $classContentGeneratorPicker = this.getClassContentGeneratorPicker();
        result = result * 59 + ($classContentGeneratorPicker == null ? 43 : $classContentGeneratorPicker.hashCode());
        ClassContentGeneratorProviderStorage $classContentGeneratorProviderStorage = this.getClassContentGeneratorProviderStorage();
        result = result * 59 + ($classContentGeneratorProviderStorage == null ? 43 : $classContentGeneratorProviderStorage.hashCode());
        return result;
    }
}

