/*
 * Decompiled with CFR 0.152.
 */
package com.github.vladislavsevruk.generator.java.context;

import com.github.vladislavsevruk.generator.java.context.ClassGenerationContext;
import com.github.vladislavsevruk.generator.java.context.ClassGenerationContextImpl;
import com.github.vladislavsevruk.generator.java.context.ClassGenerationModuleFactory;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class ClassGenerationContextManager {
    private static final ReadWriteLock DEFAULT_CONTEXT_LOCK = new ReentrantReadWriteLock();
    private static final ReadWriteLock SETTINGS_LOCK = new ReentrantReadWriteLock();
    private static boolean autoRefreshContext = true;
    private static ClassGenerationContext defaultContext = ClassGenerationContextManager.newContext();

    private ClassGenerationContextManager() {
    }

    public static void disableContextAutoRefresh() {
        ClassGenerationContextManager.autoRefreshContext(false);
    }

    public static void enableContextAutoRefresh() {
        ClassGenerationContextManager.autoRefreshContext(true);
    }

    public static ClassGenerationContext getContext() {
        DEFAULT_CONTEXT_LOCK.readLock().lock();
        ClassGenerationContext contextToReturn = defaultContext;
        DEFAULT_CONTEXT_LOCK.readLock().unlock();
        return contextToReturn;
    }

    static boolean isAutoRefreshContext() {
        SETTINGS_LOCK.readLock().lock();
        boolean valueToReturn = autoRefreshContext;
        SETTINGS_LOCK.readLock().unlock();
        return valueToReturn;
    }

    static void refreshContext() {
        DEFAULT_CONTEXT_LOCK.writeLock().lock();
        defaultContext = ClassGenerationContextManager.newContext();
        DEFAULT_CONTEXT_LOCK.writeLock().unlock();
    }

    private static void autoRefreshContext(boolean isTrue) {
        SETTINGS_LOCK.writeLock().lock();
        autoRefreshContext = isTrue;
        SETTINGS_LOCK.writeLock().unlock();
    }

    private static ClassGenerationContext newContext() {
        return new ClassGenerationContextImpl(ClassGenerationModuleFactory.classContentGeneratorPicker(), ClassGenerationModuleFactory.classContentGeneratorProviderStorage());
    }
}

