/*
 * Decompiled with CFR 0.152.
 */
package com.github.vladislavsevruk.generator.java.context;

import com.github.vladislavsevruk.generator.java.context.ClassGenerationContextManager;
import com.github.vladislavsevruk.generator.java.context.ClassGenerationModuleFactoryMethod;
import com.github.vladislavsevruk.generator.java.picker.ClassContentGeneratorPicker;
import com.github.vladislavsevruk.generator.java.storage.ClassContentGeneratorProviderStorage;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ClassGenerationModuleFactory {
    private static final ReadWriteLock CLASS_CONTENT_GENERATOR_PICKER_LOCK = new ReentrantReadWriteLock();
    private static final ReadWriteLock CLASS_CONTENT_GENERATOR_PROVIDER_STORAGE_LOCK = new ReentrantReadWriteLock();
    private static final Logger logger = LogManager.getLogger(ClassGenerationModuleFactory.class);
    private static ClassGenerationModuleFactoryMethod<ClassContentGeneratorPicker> classContentGeneratorPicker;
    private static ClassGenerationModuleFactoryMethod<ClassContentGeneratorProviderStorage> classContentGeneratorProviderStorage;

    private ClassGenerationModuleFactory() {
    }

    public static ClassGenerationModuleFactoryMethod<ClassContentGeneratorPicker> classContentGeneratorPicker() {
        CLASS_CONTENT_GENERATOR_PICKER_LOCK.readLock().lock();
        ClassGenerationModuleFactoryMethod<ClassContentGeneratorPicker> pickerToReturn = classContentGeneratorPicker;
        CLASS_CONTENT_GENERATOR_PICKER_LOCK.readLock().unlock();
        return pickerToReturn;
    }

    public static ClassGenerationModuleFactoryMethod<ClassContentGeneratorProviderStorage> classContentGeneratorProviderStorage() {
        CLASS_CONTENT_GENERATOR_PROVIDER_STORAGE_LOCK.readLock().lock();
        ClassGenerationModuleFactoryMethod<ClassContentGeneratorProviderStorage> storageToReturn = classContentGeneratorProviderStorage;
        CLASS_CONTENT_GENERATOR_PROVIDER_STORAGE_LOCK.readLock().unlock();
        return storageToReturn;
    }

    public static void replaceClassContentGeneratorPicker(ClassGenerationModuleFactoryMethod<ClassContentGeneratorPicker> picker) {
        CLASS_CONTENT_GENERATOR_PICKER_LOCK.writeLock().lock();
        logger.info(() -> String.format("Replacing ClassContentGeneratorPicker by '%s'.", picker == null ? null : picker.getClass().getName()));
        classContentGeneratorPicker = picker;
        CLASS_CONTENT_GENERATOR_PICKER_LOCK.writeLock().unlock();
        if (ClassGenerationContextManager.isAutoRefreshContext()) {
            ClassGenerationContextManager.refreshContext();
        }
    }

    public static void replaceClassContentGeneratorProviderStorage(ClassGenerationModuleFactoryMethod<ClassContentGeneratorProviderStorage> storage) {
        CLASS_CONTENT_GENERATOR_PROVIDER_STORAGE_LOCK.writeLock().lock();
        logger.info(() -> String.format("Replacing ClassContentGeneratorProviderStorage by '%s'.", storage == null ? null : storage.getClass().getName()));
        classContentGeneratorProviderStorage = storage;
        CLASS_CONTENT_GENERATOR_PROVIDER_STORAGE_LOCK.writeLock().unlock();
        if (ClassGenerationContextManager.isAutoRefreshContext()) {
            ClassGenerationContextManager.refreshContext();
        }
    }
}

