/*
 * Decompiled with CFR 0.152.
 */
package com.github.vladislavsevruk.generator.java.generator.declaration;

import com.github.vladislavsevruk.generator.java.config.JavaClassGeneratorConfig;
import com.github.vladislavsevruk.generator.java.generator.ClassElementGenerator;
import com.github.vladislavsevruk.generator.java.type.SchemaEntity;
import com.github.vladislavsevruk.generator.java.type.SchemaObject;
import com.github.vladislavsevruk.generator.java.util.DefaultValueUtil;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public abstract class BaseDeclarationGenerator
implements ClassElementGenerator {
    private List<ClassElementGenerator> classAnnotationGenerators;

    protected BaseDeclarationGenerator(List<ClassElementGenerator> classAnnotationGenerators) {
        this.classAnnotationGenerators = DefaultValueUtil.orDefault(classAnnotationGenerators, Collections::emptyList);
    }

    protected void addAnnotations(StringBuilder stringBuilder, JavaClassGeneratorConfig config, SchemaObject schemaObject) {
        this.classAnnotationGenerators.forEach(generator -> stringBuilder.append(generator.generate(config, schemaObject)));
    }

    protected void addInterfaces(StringBuilder stringBuilder, SchemaObject schemaObject) {
        List<SchemaEntity> interfaces = schemaObject.getInterfaces();
        if (interfaces != null && !interfaces.isEmpty()) {
            String interfacesLine = interfaces.stream().map(SchemaEntity::getParameterizedDeclaration).collect(Collectors.joining(", "));
            stringBuilder.append(" implements ").append(interfacesLine);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseDeclarationGenerator)) {
            return false;
        }
        BaseDeclarationGenerator other = (BaseDeclarationGenerator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<ClassElementGenerator> this$classAnnotationGenerators = this.classAnnotationGenerators;
        List<ClassElementGenerator> other$classAnnotationGenerators = other.classAnnotationGenerators;
        return !(this$classAnnotationGenerators == null ? other$classAnnotationGenerators != null : !((Object)this$classAnnotationGenerators).equals(other$classAnnotationGenerators));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseDeclarationGenerator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ClassElementGenerator> $classAnnotationGenerators = this.classAnnotationGenerators;
        result = result * 59 + ($classAnnotationGenerators == null ? 43 : ((Object)$classAnnotationGenerators).hashCode());
        return result;
    }
}

