/*
 * Decompiled with CFR 0.152.
 */
package com.github.vladislavsevruk.generator.java.generator.declaration;

import com.github.vladislavsevruk.generator.java.config.JavaClassGeneratorConfig;
import com.github.vladislavsevruk.generator.java.generator.ClassElementGenerator;
import com.github.vladislavsevruk.generator.java.generator.declaration.BaseDeclarationGenerator;
import com.github.vladislavsevruk.generator.java.type.SchemaObject;
import java.util.List;

public class ClassDeclarationGenerator
extends BaseDeclarationGenerator {
    public ClassDeclarationGenerator(List<ClassElementGenerator> classAnnotationGenerators) {
        super(classAnnotationGenerators);
    }

    @Override
    public String generate(JavaClassGeneratorConfig config, SchemaObject schemaObject) {
        StringBuilder stringBuilder = new StringBuilder("\n");
        this.addAnnotations(stringBuilder, config, schemaObject);
        stringBuilder.append("public class ").append(schemaObject.getParameterizedDeclaration());
        if (schemaObject.hasSuperclass()) {
            stringBuilder.append(" extends ").append(schemaObject.getSuperclass().getParameterizedDeclaration());
        }
        this.addInterfaces(stringBuilder, schemaObject);
        stringBuilder.append(" {\n");
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassDeclarationGenerator)) {
            return false;
        }
        ClassDeclarationGenerator other = (ClassDeclarationGenerator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ClassDeclarationGenerator;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

