/*
 * Decompiled with CFR 0.152.
 */
package com.github.vladislavsevruk.generator.java.generator.declaration;

import com.github.vladislavsevruk.generator.java.config.JavaClassGeneratorConfig;
import com.github.vladislavsevruk.generator.java.generator.ClassElementGenerator;
import com.github.vladislavsevruk.generator.java.generator.declaration.BaseDeclarationGenerator;
import com.github.vladislavsevruk.generator.java.type.SchemaEntity;
import com.github.vladislavsevruk.generator.java.type.SchemaObject;
import java.util.List;
import java.util.stream.Collectors;

public class InterfaceDeclarationGenerator
extends BaseDeclarationGenerator {
    public InterfaceDeclarationGenerator(List<ClassElementGenerator> interfaceAnnotationGenerators) {
        super(interfaceAnnotationGenerators);
    }

    @Override
    public String generate(JavaClassGeneratorConfig config, SchemaObject schemaObject) {
        StringBuilder stringBuilder = new StringBuilder("\n");
        this.addAnnotations(stringBuilder, config, schemaObject);
        stringBuilder.append("public interface ").append(schemaObject.getParameterizedDeclaration());
        List<SchemaEntity> interfaces = schemaObject.getInterfaces();
        if (!interfaces.isEmpty()) {
            String interfacesDeclaration = interfaces.stream().map(SchemaEntity::getParameterizedDeclaration).collect(Collectors.joining(", "));
            stringBuilder.append(" extends ").append(interfacesDeclaration);
        }
        stringBuilder.append(" {\n");
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InterfaceDeclarationGenerator)) {
            return false;
        }
        InterfaceDeclarationGenerator other = (InterfaceDeclarationGenerator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof InterfaceDeclarationGenerator;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

