/*
 * Decompiled with CFR 0.152.
 */
package com.github.vladislavsevruk.generator.java.generator.dependency;

import com.github.vladislavsevruk.generator.java.config.JavaClassGeneratorConfig;
import com.github.vladislavsevruk.generator.java.generator.ClassElementCollectionGenerator;
import com.github.vladislavsevruk.generator.java.type.SchemaElementSequence;
import com.github.vladislavsevruk.generator.java.type.SchemaEntity;
import com.github.vladislavsevruk.generator.java.type.SchemaObject;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AbstractImportGenerator
implements ClassElementCollectionGenerator {
    @Override
    public Collection<String> generate(JavaClassGeneratorConfig config, SchemaObject schemaObject) {
        return this.collectInnerEntities(schemaObject).stream().filter(entity -> !schemaObject.getPackage().equals(entity.getPackage())).map(this::addImport).collect(Collectors.toSet());
    }

    protected void collectInnerEntities(Set<SchemaEntity> entities, SchemaEntity schemaEntity) {
        if (schemaEntity.getPackage() != null) {
            entities.add(schemaEntity);
        }
        if (this.isSequence(schemaEntity)) {
            ((SchemaElementSequence)schemaEntity).getElementTypes().stream().filter(Objects::nonNull).forEach(entity -> this.collectInnerEntities(entities, (SchemaEntity)entity));
        }
    }

    protected abstract Set<SchemaEntity> collectInnerEntities(SchemaObject var1);

    private String addImport(SchemaEntity schemaEntity) {
        return String.format("import %s.%s;%n", schemaEntity.getPackage(), schemaEntity.getName());
    }

    private boolean isSequence(SchemaEntity schemaEntity) {
        return SchemaElementSequence.class.isAssignableFrom(schemaEntity.getClass());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractImportGenerator)) {
            return false;
        }
        AbstractImportGenerator other = (AbstractImportGenerator)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractImportGenerator;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

