/*
 * Decompiled with CFR 0.152.
 */
package com.github.vladislavsevruk.generator.java.generator.dependency;

import com.github.vladislavsevruk.generator.java.config.JavaClassGeneratorConfig;
import com.github.vladislavsevruk.generator.java.generator.ClassElementCollectionGenerator;
import com.github.vladislavsevruk.generator.java.type.SchemaEntity;
import com.github.vladislavsevruk.generator.java.type.SchemaField;
import com.github.vladislavsevruk.generator.java.type.SchemaObject;
import com.github.vladislavsevruk.generator.java.type.predefined.PrimitiveSchemaEntity;
import com.github.vladislavsevruk.generator.java.type.predefined.sequence.ArraySchemaEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class EqualsMethodImportGenerator
implements ClassElementCollectionGenerator {
    @Override
    public Collection<String> generate(JavaClassGeneratorConfig config, SchemaObject schemaObject) {
        if (config.isUseLombokAnnotations() || schemaObject.getFields().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> imports = new ArrayList<String>();
        if (this.hasNonPrimitives(schemaObject.getFields())) {
            imports.add("import java.util.Objects;\n");
        }
        if (this.hasArrays(schemaObject.getFields())) {
            imports.add("import java.util.Arrays;\n");
        }
        return imports;
    }

    private boolean hasArrays(List<SchemaField> fields) {
        return fields.stream().anyMatch(field -> ArraySchemaEntity.class.equals(field.getType().getClass()));
    }

    private boolean hasNonPrimitives(List<SchemaField> fields) {
        return fields.stream().anyMatch(field -> !ArraySchemaEntity.class.equals(field.getType().getClass()) && this.isNonPrimitive(field.getType()));
    }

    private boolean isNonPrimitive(SchemaEntity type) {
        for (PrimitiveSchemaEntity primitiveSchemaEntity : PrimitiveSchemaEntity.values()) {
            if (!primitiveSchemaEntity.equals(type)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EqualsMethodImportGenerator)) {
            return false;
        }
        EqualsMethodImportGenerator other = (EqualsMethodImportGenerator)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof EqualsMethodImportGenerator;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

