/*
 * Decompiled with CFR 0.152.
 */
package com.github.vladislavsevruk.generator.java.generator.dependency;

import com.github.vladislavsevruk.generator.java.config.JavaClassGeneratorConfig;
import com.github.vladislavsevruk.generator.java.generator.ClassElementCollectionGenerator;
import com.github.vladislavsevruk.generator.java.type.JacksonSchemaField;
import com.github.vladislavsevruk.generator.java.type.SchemaObject;
import java.util.Collection;
import java.util.Collections;

public class JacksonImportGenerator
implements ClassElementCollectionGenerator {
    @Override
    public Collection<String> generate(JavaClassGeneratorConfig config, SchemaObject schemaObject) {
        if (!config.isAddJacksonAnnotations() || this.hasNoJacksonFields(schemaObject)) {
            return Collections.emptyList();
        }
        return Collections.singleton("import com.fasterxml.jackson.annotation.JsonProperty;\n");
    }

    private boolean hasNoJacksonFields(SchemaObject schemaObject) {
        return schemaObject.getFields().stream().noneMatch(field -> JacksonSchemaField.class.isAssignableFrom(field.getClass()));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JacksonImportGenerator)) {
            return false;
        }
        JacksonImportGenerator other = (JacksonImportGenerator)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof JacksonImportGenerator;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

