/*
 * Decompiled with CFR 0.152.
 */
package com.github.vladislavsevruk.generator.java.generator.field;

import com.github.vladislavsevruk.generator.java.config.JavaClassGeneratorConfig;
import com.github.vladislavsevruk.generator.java.generator.ClassElementCollectionGenerator;
import com.github.vladislavsevruk.generator.java.generator.FieldAnnotationGenerator;
import com.github.vladislavsevruk.generator.java.type.SchemaField;
import com.github.vladislavsevruk.generator.java.type.SchemaObject;
import java.util.List;
import java.util.stream.Collectors;

public class ClassFieldGenerator
implements ClassElementCollectionGenerator {
    private List<FieldAnnotationGenerator> annotationGenerators;

    public ClassFieldGenerator(List<FieldAnnotationGenerator> annotationGenerators) {
        this.annotationGenerators = annotationGenerators;
    }

    public List<String> generate(JavaClassGeneratorConfig config, SchemaObject schemaObject) {
        return schemaObject.getFields().stream().map(field -> this.generateField(config, (SchemaField)field)).collect(Collectors.toList());
    }

    private String generateField(JavaClassGeneratorConfig config, SchemaField field) {
        StringBuilder stringBuilder = new StringBuilder();
        if (config.isAddEmptyLineBetweenFields()) {
            stringBuilder.append("\n");
        }
        this.annotationGenerators.forEach(generator -> stringBuilder.append(generator.generate(config, field)));
        return stringBuilder.append(config.getIndent().value()).append("private ").append(field.getType().getParameterizedDeclaration()).append(" ").append(field.getName()).append(";\n").toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassFieldGenerator)) {
            return false;
        }
        ClassFieldGenerator other = (ClassFieldGenerator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<FieldAnnotationGenerator> this$annotationGenerators = this.annotationGenerators;
        List<FieldAnnotationGenerator> other$annotationGenerators = other.annotationGenerators;
        return !(this$annotationGenerators == null ? other$annotationGenerators != null : !((Object)this$annotationGenerators).equals(other$annotationGenerators));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClassFieldGenerator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<FieldAnnotationGenerator> $annotationGenerators = this.annotationGenerators;
        result = result * 59 + ($annotationGenerators == null ? 43 : ((Object)$annotationGenerators).hashCode());
        return result;
    }
}

