/*
 * Decompiled with CFR 0.152.
 */
package com.github.vladislavsevruk.generator.java.generator.method;

import com.github.vladislavsevruk.generator.java.config.JavaClassGeneratorConfig;
import com.github.vladislavsevruk.generator.java.generator.method.BaseMethodGenerator;
import com.github.vladislavsevruk.generator.java.type.SchemaEntity;
import com.github.vladislavsevruk.generator.java.type.SchemaField;
import com.github.vladislavsevruk.generator.java.type.SchemaObject;
import com.github.vladislavsevruk.generator.java.type.predefined.sequence.ArraySchemaEntity;
import com.github.vladislavsevruk.generator.java.util.EntityNameUtil;
import java.util.List;

public class EqualsGenerator
extends BaseMethodGenerator {
    @Override
    public String generate(JavaClassGeneratorConfig config, SchemaObject schemaObject) {
        if (config.isUseLombokAnnotations()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder("\n");
        String objectName = schemaObject.getName();
        List<SchemaField> schemaFields = schemaObject.getFields();
        this.addOverrideAnnotation(stringBuilder, config);
        String indent = config.getIndent().value();
        stringBuilder.append(indent).append("public boolean equals(Object o) {\n");
        this.doubleIndents(stringBuilder, config).append("if (o == this) {\n");
        this.doubleIndents(stringBuilder, config).append(indent).append("return true;\n");
        this.doubleIndents(stringBuilder, config).append("}\n");
        this.addEqualsCondition(stringBuilder, config, String.format("!(o instanceof %s)", objectName));
        this.doubleIndents(stringBuilder, config).append(objectName).append(" other = (").append(objectName).append(") o;\n");
        if (schemaObject.hasSuperclass()) {
            this.addEqualsCondition(stringBuilder, config, "!super.equals(other)");
        }
        schemaFields.forEach(field -> this.addEqualsForField(stringBuilder, config, (SchemaField)field));
        this.doubleIndents(stringBuilder, config).append("return true;\n");
        this.closeMethod(stringBuilder, config);
        return stringBuilder.toString();
    }

    private void addEqualsCondition(StringBuilder stringBuilder, JavaClassGeneratorConfig config, String condition) {
        this.doubleIndents(stringBuilder, config).append("if (").append(condition).append(") {\n");
        this.doubleIndents(stringBuilder, config).append(config.getIndent().value()).append("return false;\n");
        this.doubleIndents(stringBuilder, config).append("}\n");
    }

    private void addEqualsForField(StringBuilder stringBuilder, JavaClassGeneratorConfig config, SchemaField schemaField) {
        String fieldName = EntityNameUtil.uppercaseFirstLetter(schemaField.getName());
        this.addEqualsCondition(stringBuilder, config, this.getFieldEqualsCondition(schemaField.getType(), fieldName));
    }

    private String getFieldEqualsCondition(SchemaEntity javaType, String fieldName) {
        if (ArraySchemaEntity.class.equals(javaType.getClass())) {
            return String.format("!Arrays.equals(get%s(), other.get%<s())", fieldName);
        }
        switch (javaType.getName()) {
            case "boolean": {
                return String.format("this.is%s() != other.is%<s()", fieldName);
            }
            case "byte": 
            case "char": 
            case "int": 
            case "long": 
            case "short": {
                return String.format("this.get%s() != other.get%<s()", fieldName);
            }
            case "double": {
                return String.format("Double.compare(this.get%s(), other.get%<s()) != 0", fieldName);
            }
            case "float": {
                return String.format("Float.compare(this.get%s(), other.get%<s()) != 0", fieldName);
            }
        }
        return String.format("!Objects.equals(get%s(), other.get%<s())", fieldName);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EqualsGenerator)) {
            return false;
        }
        EqualsGenerator other = (EqualsGenerator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof EqualsGenerator;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

