/*
 * Decompiled with CFR 0.152.
 */
package com.github.vladislavsevruk.generator.java.generator.method;

import com.github.vladislavsevruk.generator.java.config.JavaClassGeneratorConfig;
import com.github.vladislavsevruk.generator.java.generator.FieldAnnotationGenerator;
import com.github.vladislavsevruk.generator.java.generator.method.BaseMethodGenerator;
import com.github.vladislavsevruk.generator.java.type.SchemaField;
import com.github.vladislavsevruk.generator.java.type.SchemaObject;
import com.github.vladislavsevruk.generator.java.util.DefaultValueUtil;
import com.github.vladislavsevruk.generator.java.util.EntityNameUtil;
import java.util.Collections;
import java.util.List;

public class GetterSetterGenerator
extends BaseMethodGenerator {
    private List<FieldAnnotationGenerator> getterAnnotationGenerators;
    private List<FieldAnnotationGenerator> setterAnnotationGenerators;

    public GetterSetterGenerator(List<FieldAnnotationGenerator> getterAnnotationGenerators, List<FieldAnnotationGenerator> setterAnnotationGenerators) {
        this.getterAnnotationGenerators = DefaultValueUtil.orDefault(getterAnnotationGenerators, Collections::emptyList);
        this.setterAnnotationGenerators = DefaultValueUtil.orDefault(setterAnnotationGenerators, Collections::emptyList);
    }

    @Override
    public String generate(JavaClassGeneratorConfig config, SchemaObject schemaObject) {
        if (config.isUseLombokAnnotations()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (SchemaField field : schemaObject.getFields()) {
            this.addGetter(stringBuilder, config, field);
            this.addSetter(stringBuilder, config, schemaObject, field);
        }
        return stringBuilder.toString();
    }

    private void addGetter(StringBuilder stringBuilder, JavaClassGeneratorConfig config, SchemaField field) {
        stringBuilder.append("\n");
        String javaFieldName = field.getName();
        this.getterAnnotationGenerators.forEach(generator -> stringBuilder.append(generator.generate(config, field)));
        String javaType = field.getType().getParameterizedDeclaration();
        String getterPrefix = this.getterPrefix(javaType);
        stringBuilder.append(config.getIndent().value()).append("public ").append(javaType).append(" ").append(getterPrefix).append(EntityNameUtil.uppercaseFirstLetter(javaFieldName)).append("() {\n");
        this.doubleIndents(stringBuilder, config).append("return ").append(javaFieldName).append(";\n");
        this.closeMethod(stringBuilder, config);
    }

    private void addSetter(StringBuilder stringBuilder, JavaClassGeneratorConfig config, SchemaObject schemaObject, SchemaField field) {
        stringBuilder.append("\n");
        String javaFieldName = field.getName();
        this.setterAnnotationGenerators.forEach(generator -> stringBuilder.append(generator.generate(config, field)));
        stringBuilder.append(config.getIndent().value()).append("public ").append(schemaObject.getParameterizedDeclaration()).append(" ").append("set").append(EntityNameUtil.uppercaseFirstLetter(javaFieldName)).append("(").append(field.getType().getParameterizedDeclaration()).append(" ").append(javaFieldName).append(") {\n");
        this.doubleIndents(stringBuilder, config).append("this.").append(javaFieldName).append(" = ").append(javaFieldName).append(";\n");
        this.doubleIndents(stringBuilder, config).append("return this;\n");
        this.closeMethod(stringBuilder, config);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetterSetterGenerator)) {
            return false;
        }
        GetterSetterGenerator other = (GetterSetterGenerator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<FieldAnnotationGenerator> this$getterAnnotationGenerators = this.getterAnnotationGenerators;
        List<FieldAnnotationGenerator> other$getterAnnotationGenerators = other.getterAnnotationGenerators;
        if (this$getterAnnotationGenerators == null ? other$getterAnnotationGenerators != null : !((Object)this$getterAnnotationGenerators).equals(other$getterAnnotationGenerators)) {
            return false;
        }
        List<FieldAnnotationGenerator> this$setterAnnotationGenerators = this.setterAnnotationGenerators;
        List<FieldAnnotationGenerator> other$setterAnnotationGenerators = other.setterAnnotationGenerators;
        return !(this$setterAnnotationGenerators == null ? other$setterAnnotationGenerators != null : !((Object)this$setterAnnotationGenerators).equals(other$setterAnnotationGenerators));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof GetterSetterGenerator;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<FieldAnnotationGenerator> $getterAnnotationGenerators = this.getterAnnotationGenerators;
        result = result * 59 + ($getterAnnotationGenerators == null ? 43 : ((Object)$getterAnnotationGenerators).hashCode());
        List<FieldAnnotationGenerator> $setterAnnotationGenerators = this.setterAnnotationGenerators;
        result = result * 59 + ($setterAnnotationGenerators == null ? 43 : ((Object)$setterAnnotationGenerators).hashCode());
        return result;
    }
}

