/*
 * Decompiled with CFR 0.152.
 */
package com.github.vladislavsevruk.generator.java.generator.method;

import com.github.vladislavsevruk.generator.java.config.JavaClassGeneratorConfig;
import com.github.vladislavsevruk.generator.java.generator.method.BaseMethodGenerator;
import com.github.vladislavsevruk.generator.java.type.SchemaField;
import com.github.vladislavsevruk.generator.java.type.SchemaObject;
import com.github.vladislavsevruk.generator.java.util.EntityNameUtil;
import java.util.List;

public class HashCodeGenerator
extends BaseMethodGenerator {
    @Override
    public String generate(JavaClassGeneratorConfig config, SchemaObject schemaObject) {
        if (config.isUseLombokAnnotations()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder("\n");
        List<SchemaField> schemaFields = schemaObject.getFields();
        this.addOverrideAnnotation(stringBuilder, config);
        stringBuilder.append(config.getIndent().value()).append("public int hashCode() {\n");
        this.doubleIndents(stringBuilder, config).append("int hashCode = 1;\n");
        if (schemaObject.hasSuperclass()) {
            this.doubleIndents(stringBuilder, config).append("hashCode = 59 * hashCode + super.hashCode();\n");
        }
        schemaFields.forEach(field -> this.addHashCodeForField(stringBuilder, config, (SchemaField)field));
        this.doubleIndents(stringBuilder, config).append("return hashCode;\n");
        this.closeMethod(stringBuilder, config);
        return stringBuilder.toString();
    }

    private void addHashCodeForBoolean(StringBuilder stringBuilder, JavaClassGeneratorConfig config, String getterPrefix, String fieldName) {
        this.doubleIndents(stringBuilder, config).append("hashCode = 59 * hashCode + (").append(getterPrefix).append(fieldName).append("() ? 79 : 97);\n");
    }

    private void addHashCodeForCastingInt(StringBuilder stringBuilder, JavaClassGeneratorConfig config, String getterPrefix, String fieldName) {
        this.doubleIndents(stringBuilder, config).append("hashCode = 59 * hashCode + ");
        this.finishLineByGetter(stringBuilder, getterPrefix, fieldName);
    }

    private void addHashCodeForDouble(StringBuilder stringBuilder, JavaClassGeneratorConfig config, String getterPrefix, String fieldName) {
        this.doubleIndents(stringBuilder, config).append("long a").append(fieldName).append(" = Double.doubleToLongBits(").append(getterPrefix).append(fieldName).append("());\n");
        this.addHashCodeForLong(stringBuilder, config, fieldName);
    }

    private void addHashCodeForField(StringBuilder stringBuilder, JavaClassGeneratorConfig config, String javaType, String getterPrefix, String fieldName) {
        switch (javaType) {
            case "int": 
            case "byte": 
            case "short": 
            case "char": {
                this.addHashCodeForCastingInt(stringBuilder, config, getterPrefix, fieldName);
                break;
            }
            case "boolean": {
                this.addHashCodeForBoolean(stringBuilder, config, getterPrefix, fieldName);
                break;
            }
            case "long": {
                this.addHashCodeForLong(stringBuilder, config, getterPrefix, fieldName);
                break;
            }
            case "double": {
                this.addHashCodeForDouble(stringBuilder, config, getterPrefix, fieldName);
                break;
            }
            case "float": {
                this.addHashCodeForFloat(stringBuilder, config, getterPrefix, fieldName);
                break;
            }
            default: {
                this.addHashCodeForObject(stringBuilder, config, getterPrefix, fieldName);
            }
        }
    }

    private void addHashCodeForField(StringBuilder stringBuilder, JavaClassGeneratorConfig config, SchemaField schemaField) {
        String fieldName = EntityNameUtil.uppercaseFirstLetter(schemaField.getName());
        String getterPrefix = this.getterPrefix(schemaField);
        fieldName = EntityNameUtil.uppercaseFirstLetter(fieldName);
        String javaType = schemaField.getType().getName();
        this.addHashCodeForField(stringBuilder, config, javaType, getterPrefix, fieldName);
    }

    private void addHashCodeForFloat(StringBuilder stringBuilder, JavaClassGeneratorConfig config, String getterPrefix, String fieldName) {
        this.doubleIndents(stringBuilder, config).append("hashCode = 59 * hashCode + Float.floatToIntBits(").append(getterPrefix).append(fieldName).append("());\n");
    }

    private void addHashCodeForLong(StringBuilder stringBuilder, JavaClassGeneratorConfig config, String fieldName) {
        this.doubleIndents(stringBuilder, config).append("hashCode = 59 * hashCode + (int)(a").append(fieldName).append(" >>> 32 ^ a").append(fieldName).append(");\n");
    }

    private void addHashCodeForLong(StringBuilder stringBuilder, JavaClassGeneratorConfig config, String getterPrefix, String fieldName) {
        this.doubleIndents(stringBuilder, config).append("long a").append(fieldName).append(" = ");
        this.finishLineByGetter(stringBuilder, getterPrefix, fieldName);
        this.addHashCodeForLong(stringBuilder, config, fieldName);
    }

    private void addHashCodeForObject(StringBuilder stringBuilder, JavaClassGeneratorConfig config, String getterPrefix, String fieldName) {
        this.doubleIndents(stringBuilder, config).append("Object a").append(fieldName).append(" = ");
        this.finishLineByGetter(stringBuilder, getterPrefix, fieldName);
        this.doubleIndents(stringBuilder, config).append("hashCode = 59 * hashCode + (a").append(fieldName).append(" == null ? 0 : a").append(fieldName).append(".hashCode());\n");
    }

    private void finishLineByGetter(StringBuilder stringBuilder, String getterPrefix, String fieldName) {
        stringBuilder.append(getterPrefix).append(fieldName).append("();\n");
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HashCodeGenerator)) {
            return false;
        }
        HashCodeGenerator other = (HashCodeGenerator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof HashCodeGenerator;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

