/*
 * Decompiled with CFR 0.152.
 */
package com.github.vladislavsevruk.generator.java.generator.method;

import com.github.vladislavsevruk.generator.java.config.JavaClassGeneratorConfig;
import com.github.vladislavsevruk.generator.java.generator.method.BaseMethodGenerator;
import com.github.vladislavsevruk.generator.java.type.SchemaField;
import com.github.vladislavsevruk.generator.java.type.SchemaObject;
import com.github.vladislavsevruk.generator.java.util.EntityNameUtil;
import java.util.List;
import java.util.stream.Collectors;

public class ToStringGenerator
extends BaseMethodGenerator {
    @Override
    public String generate(JavaClassGeneratorConfig config, SchemaObject schemaObject) {
        if (config.isUseLombokAnnotations()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder("\n");
        List<SchemaField> schemaFields = schemaObject.getFields();
        this.addOverrideAnnotation(stringBuilder, config);
        stringBuilder.append(config.getIndent().value()).append("public String toString() {\n");
        this.doubleIndents(stringBuilder, config).append("return String.format(\"").append(schemaObject.getName()).append("(");
        String pattern = schemaFields.stream().map(field -> field.getName() + "=%s").collect(Collectors.joining(", "));
        if (schemaObject.hasSuperclass()) {
            stringBuilder.append("super=%s");
            if (!pattern.isEmpty()) {
                stringBuilder.append(", ");
            }
        }
        stringBuilder.append(pattern).append(")\", ");
        String fieldsSequence = schemaFields.stream().map(field -> String.format("%s%s()", this.getterPrefix((SchemaField)field), EntityNameUtil.uppercaseFirstLetter(field.getName()))).collect(Collectors.joining(", "));
        if (schemaObject.hasSuperclass()) {
            stringBuilder.append("super.toString()");
            if (!fieldsSequence.isEmpty()) {
                stringBuilder.append(", ");
            }
        }
        stringBuilder.append(fieldsSequence).append(");\n");
        this.closeMethod(stringBuilder, config);
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ToStringGenerator)) {
            return false;
        }
        ToStringGenerator other = (ToStringGenerator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ToStringGenerator;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

