/*
 * Decompiled with CFR 0.152.
 */
package com.github.vladislavsevruk.generator.java.storage;

import com.github.vladislavsevruk.generator.java.provider.ClassContentGeneratorProvider;
import com.github.vladislavsevruk.generator.java.provider.EnumContentGeneratorProvider;
import com.github.vladislavsevruk.generator.java.provider.InterfaceContentGeneratorProvider;
import com.github.vladislavsevruk.generator.java.provider.JavaClassContentGeneratorProvider;
import com.github.vladislavsevruk.generator.java.storage.ClassContentGeneratorProviderStorage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClassContentGeneratorProviderStorageImpl
implements ClassContentGeneratorProviderStorage {
    private static final ReadWriteLock PROVIDERS_LOCK = new ReentrantReadWriteLock();
    private static final Logger logger = LogManager.getLogger(ClassContentGeneratorProviderStorageImpl.class);
    private List<JavaClassContentGeneratorProvider> providers = new LinkedList<JavaClassContentGeneratorProvider>();

    public ClassContentGeneratorProviderStorageImpl() {
        this.initProviders();
    }

    @Override
    public void add(JavaClassContentGeneratorProvider customClassContentGeneratorProvider) {
        PROVIDERS_LOCK.writeLock().lock();
        this.add(this.providers.size(), customClassContentGeneratorProvider);
        PROVIDERS_LOCK.writeLock().unlock();
    }

    @Override
    public void addAfter(JavaClassContentGeneratorProvider customClassContentGeneratorProvider, Class<? extends JavaClassContentGeneratorProvider> targetType) {
        PROVIDERS_LOCK.writeLock().lock();
        int targetTypeIndex = this.getIndexOfType(targetType);
        if (targetTypeIndex == -1) {
            logger.info("Target type is not present at list, class content generator provider will be added to list end.");
            this.add(this.providers.size(), customClassContentGeneratorProvider);
        } else {
            this.add(targetTypeIndex + 1, customClassContentGeneratorProvider);
        }
        PROVIDERS_LOCK.writeLock().unlock();
    }

    @Override
    public void addBefore(JavaClassContentGeneratorProvider customClassContentGeneratorProvider, Class<? extends JavaClassContentGeneratorProvider> targetType) {
        PROVIDERS_LOCK.writeLock().lock();
        int targetTypeIndex = this.getIndexOfType(targetType);
        if (targetTypeIndex == -1) {
            logger.info("Target type is not present at list, class content generator provider will be added to list end.");
            this.add(this.providers.size(), customClassContentGeneratorProvider);
        } else {
            this.add(targetTypeIndex, customClassContentGeneratorProvider);
        }
        PROVIDERS_LOCK.writeLock().unlock();
    }

    @Override
    public List<JavaClassContentGeneratorProvider> getAll() {
        PROVIDERS_LOCK.readLock().lock();
        ArrayList<JavaClassContentGeneratorProvider> providerList = this.providers.isEmpty() ? Collections.emptyList() : new ArrayList<JavaClassContentGeneratorProvider>(this.providers);
        PROVIDERS_LOCK.readLock().unlock();
        return providerList;
    }

    private void add(int index, JavaClassContentGeneratorProvider customClassContentGeneratorProvider) {
        if (customClassContentGeneratorProvider == null) {
            logger.info("Received class content generator provider is null so it will not be added.");
            return;
        }
        int targetTypeIndex = this.getIndexOfType(customClassContentGeneratorProvider.getClass());
        if (targetTypeIndex != -1) {
            logger.info("Received class content generator provider is already present at list so it's copy will not be added.");
            return;
        }
        logger.debug(() -> String.format("Added '%s' class content generator provider.", customClassContentGeneratorProvider.getClass().getName()));
        this.providers.add(index, customClassContentGeneratorProvider);
    }

    private <T> int getIndexOfType(Class<? extends T> targetType) {
        int targetTypeIndex = -1;
        if (targetType == null) {
            logger.info("Target type is null.");
            return -1;
        }
        for (int i = 0; i < this.providers.size(); ++i) {
            if (!targetType.equals(this.providers.get(i).getClass())) continue;
            targetTypeIndex = i;
            break;
        }
        return targetTypeIndex;
    }

    private void initProviders() {
        this.providers.add(new EnumContentGeneratorProvider());
        this.providers.add(new InterfaceContentGeneratorProvider());
        this.providers.add(new ClassContentGeneratorProvider());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassContentGeneratorProviderStorageImpl)) {
            return false;
        }
        ClassContentGeneratorProviderStorageImpl other = (ClassContentGeneratorProviderStorageImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<JavaClassContentGeneratorProvider> this$providers = this.providers;
        List<JavaClassContentGeneratorProvider> other$providers = other.providers;
        return !(this$providers == null ? other$providers != null : !((Object)this$providers).equals(other$providers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClassContentGeneratorProviderStorageImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<JavaClassContentGeneratorProvider> $providers = this.providers;
        result = result * 59 + ($providers == null ? 43 : ((Object)$providers).hashCode());
        return result;
    }
}

