/*
 * Decompiled with CFR 0.152.
 */
package com.github.vladislavsevruk.generator.java.type;

import com.github.vladislavsevruk.generator.java.type.SchemaEntity;
import com.github.vladislavsevruk.generator.java.type.SchemaField;
import java.util.Objects;
import java.util.function.Supplier;

public class BaseSchemaField
implements SchemaField {
    private Supplier<SchemaEntity> delayedTypeSupplier;
    private String name;
    private SchemaEntity type;

    public BaseSchemaField(String name, SchemaEntity type) {
        this.name = name;
        this.type = type;
    }

    public BaseSchemaField(String name, Supplier<SchemaEntity> delayedTypeSupplier) {
        Objects.requireNonNull(delayedTypeSupplier, "Delayed type initialization cannot be null.");
        this.name = name;
        this.delayedTypeSupplier = delayedTypeSupplier;
    }

    @Override
    public SchemaEntity getType() {
        if (this.type == null && this.delayedTypeSupplier != null) {
            this.type = this.delayedTypeSupplier.get();
        }
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

