/*
 * Decompiled with CFR 0.152.
 */
package com.github.vladislavsevruk.generator.java.type.predefined.sequence;

import com.github.vladislavsevruk.generator.java.type.SchemaElementSequence;
import com.github.vladislavsevruk.generator.java.type.SchemaEntity;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Supplier;

public abstract class BaseSchemaElementSequence
implements SchemaElementSequence {
    private Supplier<SchemaEntity> delayedElementTypeSupplier;
    private SchemaEntity elementType;

    public BaseSchemaElementSequence(SchemaEntity elementType) {
        this.elementType = elementType;
    }

    public BaseSchemaElementSequence(Supplier<SchemaEntity> delayedElementTypeResolver) {
        Objects.requireNonNull(delayedElementTypeResolver, "Delayed type initialization cannot be null.");
        this.delayedElementTypeSupplier = delayedElementTypeResolver;
    }

    @Override
    public Collection<SchemaEntity> getElementTypes() {
        return Collections.singletonList(this.getElementType());
    }

    protected SchemaEntity getElementType() {
        if (this.elementType == null && this.delayedElementTypeSupplier != null) {
            this.elementType = this.delayedElementTypeSupplier.get();
        }
        return this.elementType;
    }
}

