/*
 * Decompiled with CFR 0.152.
 */
package com.github.vladislavsevruk.generator.java.type.predefined.sequence;

import com.github.vladislavsevruk.generator.java.type.SchemaElementSequence;
import com.github.vladislavsevruk.generator.java.type.SchemaEntity;
import com.github.vladislavsevruk.generator.java.type.predefined.CommonJavaSchemaEntity;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Supplier;

public class MapSchemaEntity
implements SchemaElementSequence {
    private Supplier<SchemaEntity> delayedKeyTypeSupplier;
    private Supplier<SchemaEntity> delayedValueTypeSupplier;
    private SchemaEntity keyType;
    private SchemaEntity valueType;

    public MapSchemaEntity() {
    }

    public MapSchemaEntity(SchemaEntity keyType, SchemaEntity valueType) {
        this.keyType = keyType;
        this.valueType = valueType;
    }

    public MapSchemaEntity(Supplier<SchemaEntity> delayedKeyTypeSupplier, Supplier<SchemaEntity> delayedValueTypeSupplier) {
        this.delayedKeyTypeSupplier = delayedKeyTypeSupplier;
        this.delayedValueTypeSupplier = delayedValueTypeSupplier;
    }

    @Override
    public Collection<SchemaEntity> getElementTypes() {
        return Arrays.asList(this.getKeyType(), this.getValueType());
    }

    @Override
    public String getName() {
        return "Map";
    }

    @Override
    public String getPackage() {
        return "java.util";
    }

    @Override
    public String getParameterizedDeclaration() {
        SchemaEntity keySchemaEntity = this.getKeyType();
        SchemaEntity valueSchemaEntity = this.getValueType();
        if (keySchemaEntity == null && valueSchemaEntity == null) {
            return this.getName();
        }
        if (keySchemaEntity == null) {
            keySchemaEntity = CommonJavaSchemaEntity.OBJECT;
        }
        if (valueSchemaEntity == null) {
            valueSchemaEntity = CommonJavaSchemaEntity.OBJECT;
        }
        return String.format("%s<%s, %s>", this.getName(), keySchemaEntity.getName(), valueSchemaEntity.getName());
    }

    protected SchemaEntity getKeyType() {
        if (this.keyType == null && this.delayedKeyTypeSupplier != null) {
            this.keyType = this.delayedKeyTypeSupplier.get();
        }
        return this.keyType;
    }

    protected SchemaEntity getValueType() {
        if (this.valueType == null && this.delayedValueTypeSupplier != null) {
            this.valueType = this.delayedValueTypeSupplier.get();
        }
        return this.valueType;
    }
}

