/*
 * Decompiled with CFR 0.152.
 */
package com.github.vladislavsevruk.generator.java.util;

public final class EntityNameUtil {
    private EntityNameUtil() {
    }

    public static String getJavaFormatClassName(String name) {
        return EntityNameUtil.uppercaseFirstLetter(EntityNameUtil.removeUnderscores(name));
    }

    public static String getJavaFormatFieldName(String name) {
        return EntityNameUtil.lowercaseFirstLetter(EntityNameUtil.removeUnderscores(name));
    }

    public static String lowercaseFirstLetter(String name) {
        int firstLetterCodePoint = name.codePointAt(0);
        if (firstLetterCodePoint >= 65 && firstLetterCodePoint <= 90) {
            return (char)(firstLetterCodePoint += 32) + name.substring(1);
        }
        return name;
    }

    public static String uppercaseFirstLetter(String name) {
        int firstLetterCodePoint = name.codePointAt(0);
        if (firstLetterCodePoint >= 97 && firstLetterCodePoint <= 122) {
            return (char)(firstLetterCodePoint -= 32) + name.substring(1);
        }
        return name;
    }

    private static String removeUnderscores(String name) {
        int underscoreIndex = name.indexOf(95);
        if (underscoreIndex == -1) {
            return name;
        }
        StringBuilder stringBuilder = new StringBuilder();
        do {
            stringBuilder.append(name, 0, underscoreIndex);
        } while ((underscoreIndex = (name = EntityNameUtil.uppercaseFirstLetter(name.substring(underscoreIndex + 1))).indexOf(95)) != -1);
        return stringBuilder.append(name).toString();
    }
}

