/*
 * Decompiled with CFR 0.152.
 */
package com.github.vladislavsevruk.generator.java.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class FileUtil {
    private static final Logger logger = LogManager.getLogger(FileUtil.class);

    private FileUtil() {
    }

    public static String addPathSeparator(String dirPath) {
        if (dirPath.endsWith(File.separator)) {
            return dirPath;
        }
        return dirPath + File.separator;
    }

    public static void recursiveMkdir(String path) {
        if (!new File(path).exists()) {
            int pathSeparatorIndex = path.lastIndexOf(File.separator);
            if (pathSeparatorIndex != -1) {
                FileUtil.recursiveMkdir(path.substring(0, pathSeparatorIndex));
            }
            logger.info(() -> String.format("Creating '%s' folder.", path));
            new File(path).mkdir();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String writeToFile(File file, String classContent) {
        try (FileWriter fileWriter = new FileWriter(file);){
            fileWriter.write(classContent);
            String string = file.getPath();
            return string;
        }
        catch (IOException ioEx) {
            logger.error(() -> "Failed to write to file: " + file.getAbsolutePath());
            return null;
        }
    }

    public static String writeToNewFile(File file, String classContent) {
        if (file.exists()) {
            logger.warn(() -> "File already exists: " + file.getAbsolutePath());
            return null;
        }
        return FileUtil.writeToFile(file, classContent);
    }

    public static String writeToNewFile(String filePath, String classContent) {
        return FileUtil.writeToNewFile(new File(filePath), classContent);
    }
}

