/*
 * Decompiled with CFR 0.152.
 */
package com.github.wangran99.welink.api.client.autoconfigure;

import com.github.wangran99.welink.api.client.openapi.CustomGsonConverterFactory;
import com.github.wangran99.welink.api.client.openapi.HeaderInterceptor;
import com.github.wangran99.welink.api.client.openapi.OpenAPI;
import com.github.wangran99.welink.api.client.openapi.OpenManagerApi;
import com.github.wangran99.welink.api.client.openapi.SynchronousCallAdapterFactory;
import com.github.wangran99.welink.api.client.openapi.model.AuthReq;
import com.github.wangran99.welink.api.client.openapi.model.AuthRes;
import com.github.wangran99.welink.api.client.openapi.model.TenantInfoRes;
import com.github.wangran99.welink.api.client.properties.WelinkOpenApiProperties;
import com.github.wangran99.welink.api.client.timer.AuthorizationTimer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;

@Configuration
@EnableConfigurationProperties(value={WelinkOpenApiProperties.class})
public class WelinkOpenApiAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(WelinkOpenApiAutoConfiguration.class);
    private final String baseUrl = "https://open.welink.huaweicloud.com/api/";
    private static final String patten = "yyyy-MM-dd HH:mm:ss";
    static final JsonSerializer<LocalDateTime> jsonSerializerDateTime = (localDateTime, type, jsonSerializationContext) -> new JsonPrimitive(localDateTime.format(DateTimeFormatter.ofPattern(patten)));
    static final JsonSerializer<LocalDate> jsonSerializerDate = (localDate, type, jsonSerializationContext) -> new JsonPrimitive(localDate.format(DateTimeFormatter.ISO_LOCAL_DATE));
    static final JsonDeserializer<LocalDateTime> jsonDeserializerDateTime = (jsonElement, type, jsonDeserializationContext) -> LocalDateTime.parse(jsonElement.getAsJsonPrimitive().getAsString(), DateTimeFormatter.ofPattern(patten));
    static final JsonDeserializer<LocalDate> jsonDeserializerDate = (jsonElement, type, jsonDeserializationContext) -> LocalDate.parse(jsonElement.getAsJsonPrimitive().getAsString(), DateTimeFormatter.ISO_LOCAL_DATE);
    @Autowired
    private WelinkOpenApiProperties welinkOpenApiProperties;

    CustomGsonConverterFactory customGsonConverterFactory() {
        return new CustomGsonConverterFactory(this.gson());
    }

    @Bean
    Gson gson() {
        return new GsonBuilder().setLenient().setPrettyPrinting().setDateFormat(patten).registerTypeAdapter(LocalDateTime.class, jsonSerializerDateTime).registerTypeAdapter(LocalDate.class, jsonSerializerDate).registerTypeAdapter(LocalDateTime.class, jsonDeserializerDateTime).registerTypeAdapter(LocalDate.class, jsonDeserializerDate).create();
    }

    @Bean
    AuthorizationTimer authorizationTimer() {
        return new AuthorizationTimer();
    }

    @Bean
    AuthReq authReq() {
        AuthReq req = new AuthReq();
        req.setClient_id(this.welinkOpenApiProperties.getClientId());
        req.setClient_secret(this.welinkOpenApiProperties.getClientSecret());
        return req;
    }

    @Bean
    AuthRes authRes() {
        AuthRes res = new AuthRes();
        return res;
    }

    @Bean
    TenantInfoRes tenantInfoRes() {
        TenantInfoRes tenantInfoRes = new TenantInfoRes();
        return tenantInfoRes;
    }

    @Bean
    HeaderInterceptor headerInterceptor() {
        return new HeaderInterceptor();
    }

    public Retrofit getRetrofit(HeaderInterceptor headerInterceptor) {
        HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor();
        loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        OkHttpClient okHttpClient = new OkHttpClient.Builder().addInterceptor((Interceptor)headerInterceptor).addInterceptor((Interceptor)loggingInterceptor).retryOnConnectionFailure(true).connectionPool(new ConnectionPool(10, 1L, TimeUnit.SECONDS)).build();
        Retrofit retrofit = new Retrofit.Builder().baseUrl("https://open.welink.huaweicloud.com/api/").client(okHttpClient).addCallAdapterFactory((CallAdapter.Factory)new SynchronousCallAdapterFactory()).addConverterFactory((Converter.Factory)this.customGsonConverterFactory()).build();
        return retrofit;
    }

    @Bean
    public OpenAPI openAPI(HeaderInterceptor headerInterceptor) {
        return (OpenAPI)this.getRetrofit(headerInterceptor).create(OpenAPI.class);
    }

    @Bean
    public OpenManagerApi openManagerApi(HeaderInterceptor headerInterceptor) {
        return (OpenManagerApi)this.getRetrofit(headerInterceptor).create(OpenManagerApi.class);
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public WelinkOpenApiProperties getWelinkOpenApiProperties() {
        return this.welinkOpenApiProperties;
    }

    public void setWelinkOpenApiProperties(WelinkOpenApiProperties welinkOpenApiProperties) {
        this.welinkOpenApiProperties = welinkOpenApiProperties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WelinkOpenApiAutoConfiguration)) {
            return false;
        }
        WelinkOpenApiAutoConfiguration other = (WelinkOpenApiAutoConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$baseUrl = this.getBaseUrl();
        String other$baseUrl = other.getBaseUrl();
        if (this$baseUrl == null ? other$baseUrl != null : !this$baseUrl.equals(other$baseUrl)) {
            return false;
        }
        WelinkOpenApiProperties this$welinkOpenApiProperties = this.getWelinkOpenApiProperties();
        WelinkOpenApiProperties other$welinkOpenApiProperties = other.getWelinkOpenApiProperties();
        return !(this$welinkOpenApiProperties == null ? other$welinkOpenApiProperties != null : !((Object)this$welinkOpenApiProperties).equals(other$welinkOpenApiProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WelinkOpenApiAutoConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $baseUrl = this.getBaseUrl();
        result = result * 59 + ($baseUrl == null ? 43 : $baseUrl.hashCode());
        WelinkOpenApiProperties $welinkOpenApiProperties = this.getWelinkOpenApiProperties();
        result = result * 59 + ($welinkOpenApiProperties == null ? 43 : ((Object)$welinkOpenApiProperties).hashCode());
        return result;
    }

    public String toString() {
        return "WelinkOpenApiAutoConfiguration(baseUrl=" + this.getBaseUrl() + ", welinkOpenApiProperties=" + this.getWelinkOpenApiProperties() + ")";
    }
}

