/*
 * Decompiled with CFR 0.152.
 */
package com.github.wangran99.welink.api.client.openapi;

import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;

public abstract class CallFactoryProxy
implements Call.Factory {
    private static final Logger log = LoggerFactory.getLogger(CallFactoryProxy.class);
    private static final String NAME_BASE_URL = "BaseUrlName";
    private final Call.Factory delegate;

    public CallFactoryProxy(Call.Factory delegate) {
        this.delegate = delegate;
    }

    public Call newCall(Request request) {
        String baseUrlName = request.header(NAME_BASE_URL);
        if (baseUrlName != null) {
            HttpUrl newHttpUrl = this.getNewUrl(baseUrlName, request);
            if (newHttpUrl != null) {
                Request newRequest = request.newBuilder().url(newHttpUrl).build();
                return this.delegate.newCall(newRequest);
            }
            log.info("getNewUrl() return null when baseUrlName==" + baseUrlName);
        }
        return this.delegate.newCall(request);
    }

    @Nullable
    protected abstract HttpUrl getNewUrl(String var1, Request var2);
}

