/*
 * Decompiled with CFR 0.152.
 */
package com.github.wangran99.welink.api.client.openapi;

import com.github.wangran99.welink.api.client.openapi.model.IException;

public class CommonException
extends RuntimeException {
    public static final int SUCCESS_CODE = 0;
    public static final int FAIL_CODE = 1;
    private int code;
    private String msg;

    public CommonException(int code, String msg) {
        super(msg);
        this.msg = msg;
        this.code = code;
    }

    public CommonException(String codeString, String msg) {
        super(msg);
        this.msg = msg;
        this.code = Integer.parseInt(codeString);
    }

    public CommonException(String msg) {
        super(msg);
        this.msg = msg;
        this.code = 1;
    }

    public CommonException(IException iException) {
        super(iException.getDesc());
        this.msg = iException.getDesc();
        this.code = iException.getCode();
    }

    public CommonException(Throwable cause) {
        super(cause);
        this.code = 1;
    }

    public int getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommonException)) {
            return false;
        }
        CommonException other = (CommonException)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        return !(this$msg == null ? other$msg != null : !this$msg.equals(other$msg));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CommonException;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "CommonException(code=" + this.getCode() + ", msg=" + this.getMsg() + ")";
    }
}

