/*
 * Decompiled with CFR 0.152.
 */
package com.github.wangran99.welink.api.client.openapi;

import com.github.wangran99.welink.api.client.openapi.model.OpenApiException;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Converter;

final class CustomGsonResponseBodyConverter<T>
implements Converter<ResponseBody, T> {
    private static final Logger log = LoggerFactory.getLogger(CustomGsonResponseBodyConverter.class);
    private final Gson gson;
    private final TypeAdapter<T> adapter;

    CustomGsonResponseBodyConverter(Gson gson, TypeAdapter<T> adapter) {
        this.gson = gson;
        this.adapter = adapter;
    }

    public T convert(ResponseBody value) throws IOException {
        int code;
        String response = value.string();
        value.close();
        log.debug(response);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(response.getBytes());
        InputStreamReader reader1 = new InputStreamReader(inputStream);
        JsonReader jsonReader = this.gson.newJsonReader((Reader)reader1);
        JsonObject jsonObject = JsonParser.parseReader((JsonReader)jsonReader).getAsJsonObject();
        int n = code = jsonObject.get("code") == null ? 0 : jsonObject.get("code").getAsInt();
        if (code != 0 && code != 60001 && code != 58003 && code != 47012 && code != 47009) {
            OpenApiException e = new OpenApiException(code, "open api error." + jsonObject.get("message").getAsString());
            throw e;
        }
        if (jsonObject.get("data") == null && jsonObject.get("limit") != null) {
            return (T)this.adapter.fromJson(response);
        }
        if (jsonObject.get("data") == null || jsonObject.get("data") != null && jsonObject.get("pageNo") != null) {
            return (T)this.adapter.fromJson(response);
        }
        if (jsonObject.get("data").isJsonArray()) {
            return (T)this.adapter.fromJson(jsonObject.get("data").getAsJsonArray().toString());
        }
        return (T)this.adapter.fromJsonTree((JsonElement)jsonObject.get("data").getAsJsonObject());
    }
}

