/*
 * Decompiled with CFR 0.152.
 */
package com.github.wangran99.welink.api.client.openapi.model;

import com.github.wangran99.welink.api.client.openapi.model.IException;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

public class ResultVO {
    public static final int SUCCESS_CODE = 0;
    public static final int FAIL_CODE = 1;
    public static final int AUTH_FAIL_OR_EXPIRED = 2;
    private int code;
    private String msg;
    private Object data;

    public ResultVO() {
    }

    public ResultVO(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public ResultVO(int code, String msg, Object data) {
        this.code = code;
        this.msg = msg;
        this.data = data;
    }

    public static ResultVO getSuccess() {
        return new ResultVO(0, "success");
    }

    public static ResultVO getSuccess(Object data) {
        ResultVO resultVO = new ResultVO(0, "success", data);
        return resultVO;
    }

    public static ResultVO getSuccess(Object data, String msg) {
        ResultVO resultVO = new ResultVO(0, msg, data);
        return resultVO;
    }

    public static ResultVO getAuthFailOrExpired(String errorMessage, String redirectUrl) {
        return new ResultVO(2, errorMessage, redirectUrl);
    }

    public static ResultVO getError() {
        return new ResultVO(1, "request failed.");
    }

    public static ResultVO getError(String errorMessage) {
        return new ResultVO(1, errorMessage);
    }

    public Object convertClass(Class clazz) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson(this.data);
        return gson.fromJson(json, clazz);
    }

    public static ResultVO getError(int code, String errorMessage) {
        return new ResultVO(code, errorMessage);
    }

    public static ResultVO getError(IException e) {
        return new ResultVO(e.getCode(), e.getDesc());
    }

    public int getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public Object getData() {
        return this.data;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResultVO)) {
            return false;
        }
        ResultVO other = (ResultVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        Object this$data = this.getData();
        Object other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResultVO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        Object $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "ResultVO(code=" + this.getCode() + ", msg=" + this.getMsg() + ", data=" + this.getData() + ")";
    }
}

