/*
 * Decompiled with CFR 0.152.
 */
package com.github.wangran99.welink.api.client.timer;

import com.github.wangran99.welink.api.client.openapi.OpenAPI;
import com.github.wangran99.welink.api.client.openapi.model.AuthReq;
import com.github.wangran99.welink.api.client.openapi.model.AuthRes;
import com.github.wangran99.welink.api.client.openapi.model.TenantInfoRes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;

public class AuthorizationTimer {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationTimer.class);
    @Autowired
    private OpenAPI openAPI;
    @Autowired
    private AuthReq authReq;
    @Autowired
    private AuthRes authRes;
    @Autowired
    private TenantInfoRes tenantInfoRes;

    @Scheduled(fixedRateString="1800000")
    public void scheduled() {
        log.info("==================>>>>>begin update token by auth timer<<<<<================");
        AuthRes authResponse = this.openAPI.auth(this.authReq);
        this.authRes.setAccess_token(authResponse.getAccess_token());
        this.authRes.setExpires_in(authResponse.getExpires_in());
        TenantInfoRes tenantInfoResponse = this.openAPI.getTenantInfo();
        BeanUtils.copyProperties((Object)tenantInfoResponse, (Object)this.tenantInfoRes);
        log.info("===================>>>>>end update token by auth timer<<<<<=================");
    }
}

