/*
 * Decompiled with CFR 0.152.
 */
package com.github.wasiqb.coteafs.selenium.config;

import com.github.wasiqb.coteafs.selenium.constants.OS;
import java.net.URL;

public enum AvailableBrowser {
    CHROME("webdriver.chrome.driver", "chromedriver"),
    FIREFOX("webdriver.gecko.driver", "geckodriver"),
    IE("webdriver.ie.driver", "IEDriverServer");

    private static final String DEFAULT_FOLDER = "drivers/";
    private String driver;
    private String key;

    private AvailableBrowser(String key, String driver) {
        this.key = key;
        this.driver = driver;
        this.setup();
    }

    private void setup() {
        if (System.getProperty(this.key) == null) {
            StringBuilder sb = new StringBuilder();
            URL dir = AvailableBrowser.class.getClassLoader().getResource(DEFAULT_FOLDER);
            sb.append(dir.getPath());
            sb.append(OS.platform()).append("/").append(this.driver);
            if (OS.isWindows()) {
                sb.append(".exe");
            }
            System.setProperty(this.key, sb.toString());
        }
    }
}

