/*
 * Decompiled with CFR 0.152.
 */
package com.github.wasiqb.coteafs.selenium.core;

import com.github.wasiqb.coteafs.selenium.config.AvailableBrowser;
import com.github.wasiqb.coteafs.selenium.config.ConfigUtil;
import com.github.wasiqb.coteafs.selenium.config.DelaySetting;
import com.github.wasiqb.coteafs.selenium.config.PlaybackSetting;
import com.github.wasiqb.coteafs.selenium.config.ScreenResolution;
import com.github.wasiqb.coteafs.selenium.config.ScreenState;
import com.github.wasiqb.coteafs.selenium.constants.OS;
import com.github.wasiqb.coteafs.selenium.core.BrowserActions;
import com.github.wasiqb.coteafs.selenium.listeners.DriverListner;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeDriverService;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.GeckoDriverService;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.ie.InternetExplorerDriverService;
import org.openqa.selenium.ie.InternetExplorerOptions;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.support.events.EventFiringWebDriver;
import org.openqa.selenium.support.events.WebDriverEventListener;
import org.testng.Assert;

public class Browser {
    private static final ThreadLocal<EventFiringWebDriver> driverThread = new ThreadLocal();
    private static WebDriverEventListener listener;
    private static final Logger log;

    public static void close() {
        int handles = Browser.driver().getWindowHandles().size();
        if (handles > 1) {
            log.info("Closing the browser...");
            Browser.driver().close();
        } else {
            Browser.stop();
        }
    }

    private static EventFiringWebDriver driver() {
        return driverThread.get();
    }

    private static void driver(EventFiringWebDriver driver) {
        driverThread.set(driver);
    }

    private static void manageOptions(Consumer<WebDriver.Options> options) {
        options.accept(Browser.driver().manage());
    }

    private static void manageTimeouts(Consumer<WebDriver.Timeouts> timeouts) {
        timeouts.accept(Browser.driver().manage().timeouts());
    }

    private static void manageWindow(Consumer<WebDriver.Window> window) {
        window.accept(Browser.driver().manage().window());
    }

    private static void setScreenSize(PlaybackSetting playback) {
        ScreenState state = playback.getScreenState();
        log.info("Setting screen size of Browser to {}...", (Object)state);
        switch (state) {
            case FULL_SCREEN: {
                Browser.manageWindow(WebDriver.Window::fullscreen);
                break;
            }
            case MAXIMIZED: {
                Browser.manageWindow(WebDriver.Window::maximize);
                break;
            }
            default: {
                ScreenResolution resolution = playback.getScreenResolution();
                log.info("Setting screen resolution to [{}]...", (Object)resolution);
                Browser.manageWindow(w -> w.setSize(new Dimension(resolution.getWidth(), resolution.getHeight())));
            }
        }
    }

    private static WebDriver setupChromeDriver() {
        log.info("Setting up Chrome driver...");
        ChromeOptions chromeOptions = new ChromeOptions();
        chromeOptions.addArguments(new String[]{"--dns-prefetch-disable"});
        if (ConfigUtil.appSetting().isHeadlessMode()) {
            chromeOptions.addArguments(new String[]{"--headless"});
        }
        chromeOptions.setCapability("acceptSslCerts", true);
        ChromeDriverService chromeService = ChromeDriverService.createDefaultService();
        return new ChromeDriver(chromeService, chromeOptions);
    }

    private static WebDriver setupDriver(AvailableBrowser browser) {
        switch (browser) {
            case CHROME: {
                return Browser.setupChromeDriver();
            }
            case IE: {
                return Browser.setupIEDriver();
            }
        }
        return Browser.setupFirefoxDriver();
    }

    private static void setupDriverOptions() {
        PlaybackSetting playback = ConfigUtil.appSetting().getPlayback();
        DelaySetting delays = playback.getDelays();
        Browser.manageTimeouts(t -> t.pageLoadTimeout(delays.getPageLoad(), TimeUnit.SECONDS));
        Browser.manageTimeouts(t -> t.setScriptTimeout(delays.getScriptLoad(), TimeUnit.SECONDS));
        Browser.manageTimeouts(t -> t.implicitlyWait(delays.getImplicit(), TimeUnit.SECONDS));
        Browser.manageOptions(WebDriver.Options::deleteAllCookies);
        Browser.setScreenSize(playback);
    }

    private static WebDriver setupFirefoxDriver() {
        log.info("Setting up Firefox driver...");
        DesiredCapabilities capabilities = DesiredCapabilities.firefox();
        FirefoxOptions options = new FirefoxOptions((Capabilities)capabilities);
        GeckoDriverService firefoxService = GeckoDriverService.createDefaultService();
        return new FirefoxDriver(firefoxService, options);
    }

    private static WebDriver setupIEDriver() {
        log.info("Setting up Internet Explorer driver...");
        InternetExplorerOptions ieOptions = new InternetExplorerOptions();
        ieOptions.destructivelyEnsureCleanSession();
        ieOptions.setCapability("requireWindowFocus", true);
        ieOptions.setCapability("acceptSslCerts", true);
        InternetExplorerDriverService ieService = InternetExplorerDriverService.createDefaultService();
        if (OS.isMac() || OS.isUnix()) {
            Assert.fail((String)"IE is not supported.");
        }
        if (ConfigUtil.appSetting().isHeadlessMode()) {
            Assert.fail((String)"Internet Explorer can not run in headless mode, Set Headless setting to false in config.yaml");
        }
        return new InternetExplorerDriver(ieService, ieOptions);
    }

    static BrowserActions interact() {
        return new BrowserActions(Browser.driver());
    }

    static void start(String browserName) {
        log.info("Starting the browser...");
        String target = browserName;
        if (target == null) {
            target = System.getProperty("coteafs.browser", ConfigUtil.appSetting().getBrowser().name());
        }
        AvailableBrowser browser = AvailableBrowser.valueOf(target.toUpperCase());
        WebDriver driver = Browser.setupDriver(browser);
        EventFiringWebDriver wd = new EventFiringWebDriver(driver);
        listener = new DriverListner();
        wd.register(listener);
        Browser.driver(wd);
        Browser.setupDriverOptions();
    }

    static void stop() {
        log.info("Stopping the browser...");
        Browser.driver().unregister(listener).quit();
        Browser.driver(null);
    }

    private Browser() {
    }

    static {
        log = LogManager.getLogger(Browser.class);
    }
}

