/*
 * Decompiled with CFR 0.152.
 */
package com.github.wasiqb.coteafs.selenium.core;

import com.github.wasiqb.coteafs.selenium.config.ConfigUtil;
import com.google.common.truth.StringSubject;
import com.google.common.truth.Truth;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openqa.selenium.Alert;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.events.EventFiringWebDriver;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class BrowserActions {
    private static final Logger log = LogManager.getLogger(BrowserActions.class);
    private final EventFiringWebDriver driver;
    private final WebDriverWait wait;

    public BrowserActions(EventFiringWebDriver driver) {
        this.driver = driver;
        this.wait = new WebDriverWait((WebDriver)driver, ConfigUtil.appSetting().getPlayback().getDelays().getExplicit());
    }

    public String acceptAlert() {
        Alert alert = (Alert)this.wait.until((Function)ExpectedConditions.alertIsPresent());
        String message = null;
        if (alert != null) {
            message = alert.getText();
            alert.accept();
        }
        return message;
    }

    public void back() {
        this.perform(d -> d.navigate().back());
    }

    public void deleteCookies() {
        this.perform(d -> d.manage().deleteAllCookies());
    }

    public String dismissAlert() {
        Alert alert = (Alert)this.wait.until((Function)ExpectedConditions.alertIsPresent());
        String message = "";
        if (alert != null) {
            message = alert.getText();
            alert.dismiss();
        }
        return message;
    }

    public WebDriverWait driverWait() {
        return this.wait;
    }

    public <E> E executeScript(String script, Object ... args) {
        return (E)this.get(d -> d.executeScript(script, args));
    }

    public void forward() {
        this.perform(d -> d.navigate().forward());
    }

    public boolean isClosed() {
        return this.get(d -> ((RemoteWebDriver)d.getWrappedDriver()).getSessionId() == null);
    }

    public void navigateTo(String url) {
        this.perform(d -> d.navigate().to(url));
    }

    public void refresh() {
        this.perform(d -> d.navigate().refresh());
    }

    public byte[] saveScreenshot() {
        return this.get(d -> (byte[])d.getScreenshotAs(OutputType.BYTES));
    }

    public void saveScreenshot(String filePath) {
        File screenShot = this.get(d -> (File)d.getScreenshotAs(OutputType.FILE));
        try {
            log.info("Saving screen shot to file: {}...", (Object)filePath);
            FileUtils.copyFile((File)screenShot, (File)new File(filePath));
        }
        catch (IOException e) {
            log.error(String.format("Error while saving screenshot to file: %s", filePath));
            log.catching((Throwable)e);
        }
    }

    public void switchToMain() {
        this.perform(d -> d.switchTo().defaultContent());
    }

    public void switchToWindow(String title) {
        this.perform(d -> {
            String currentHandle = d.getWindowHandle();
            Set wins = d.getWindowHandles();
            for (String win : wins) {
                WebDriver w;
                if (currentHandle.equals(win) || !(w = d.switchTo().window(win)).getTitle().contains(title)) continue;
                return;
            }
        });
    }

    public String title() {
        return this.get(WebDriver::getTitle);
    }

    public StringSubject verifyAcceptedAlertMessage() {
        String actual = this.acceptAlert();
        return Truth.assertThat((String)actual);
    }

    public StringSubject verifyDismissedAlertMessage() {
        String actual = this.dismissAlert();
        return Truth.assertThat((String)actual);
    }

    private <E> E get(Function<EventFiringWebDriver, E> func) {
        return func.apply(this.driver);
    }

    private void perform(Consumer<EventFiringWebDriver> action) {
        action.accept(this.driver);
    }

    EventFiringWebDriver driver() {
        return this.driver;
    }
}

