/*
 * Decompiled with CFR 0.152.
 */
package com.github.wasiqb.coteafs.selenium.core;

import com.github.wasiqb.coteafs.selenium.config.ConfigUtil;
import com.github.wasiqb.coteafs.selenium.core.Browser;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Optional;
import org.testng.annotations.Parameters;

public class BrowserTest {
    @Parameters(value={"test.browser"})
    @BeforeTest(alwaysRun=true)
    public void setupTest(@Optional String browserName) {
        Browser.start(browserName);
    }

    @AfterMethod(alwaysRun=true)
    public void teardownMethod(ITestResult result) {
        boolean screenshotOnError = ConfigUtil.appSetting().getPlayback().getScreenshot().isCaptureOnError();
        if (screenshotOnError && result.getStatus() == 2 && !Browser.interact().isClosed()) {
            Browser.interact().saveScreenshot();
        }
    }

    @AfterTest(alwaysRun=true)
    public void teardownTest() {
        Browser.close();
    }
}

