/*
 * Decompiled with CFR 0.152.
 */
package com.github.wasiqb.coteafs.selenium.core;

import com.github.wasiqb.coteafs.selenium.config.ConfigUtil;
import com.github.wasiqb.coteafs.selenium.config.DelaySetting;
import com.github.wasiqb.coteafs.selenium.core.BrowserActions;
import com.google.common.truth.BooleanSubject;
import com.google.common.truth.StringSubject;
import com.google.common.truth.Truth;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.events.EventFiringWebDriver;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class ElementAction {
    private static final Logger LOG = LogManager.getLogger(ElementAction.class);
    private final Actions actions;
    private boolean alreadyHighlighted;
    private final BrowserActions browserAction;
    private By by;
    private final DelaySetting delays;
    private final EventFiringWebDriver driver;
    private WebElement element;
    private String style;
    private boolean useBy;
    private final WebDriverWait wait;

    private static void pause(long delay) {
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException e) {
            LOG.error("Error while pausing: {}", (Object)e.getMessage());
            Thread.currentThread().interrupt();
        }
    }

    public ElementAction(BrowserActions browserAction, By by) {
        this(browserAction);
        this.by = by;
        this.useBy = true;
    }

    public ElementAction(BrowserActions browserAction, WebElement element) {
        this(browserAction);
        this.element = element;
        this.useBy = false;
    }

    private ElementAction(BrowserActions browserAction) {
        this.browserAction = browserAction;
        this.driver = browserAction.driver();
        this.actions = new Actions((WebDriver)this.driver);
        this.wait = browserAction.driverWait();
        this.alreadyHighlighted = false;
        this.delays = ConfigUtil.appSetting().getPlayback().getDelays();
    }

    public String attribute(String name) {
        return this.get(e -> e.getAttribute(name));
    }

    public void clear() {
        this.perform(WebElement::clear);
    }

    public void click() {
        this.perform(e -> {
            ElementAction.pause(this.delays.getBeforeClick());
            e.click();
            ElementAction.pause(this.delays.getAfterClick());
        });
    }

    public void enterText(String text) {
        this.perform(e -> {
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{text})) {
                ElementAction.pause(this.delays.getBeforeTyping());
                e.sendKeys(new CharSequence[]{text});
                ElementAction.pause(this.delays.getAfterTyping());
            }
        });
    }

    public ElementAction find(By byLocator) {
        return this.get(e -> new ElementAction(this.browserAction, e.findElement(byLocator)));
    }

    public List<ElementAction> finds(By byLocator) {
        return this.get(e -> e.findElements(byLocator)).stream().map(e -> new ElementAction(this.browserAction, (WebElement)e)).collect(Collectors.toList());
    }

    public void hover() {
        this.perform(e -> this.actions.pause(Duration.ofMillis(this.delays.getBeforeMouseMove())).moveToElement(e).pause(Duration.ofMillis(this.delays.getAfterMouseMove())).perform());
    }

    public boolean isDisplayed() {
        return this.get(WebElement::isDisplayed);
    }

    public boolean isEnabled() {
        return this.get(WebElement::isEnabled);
    }

    public boolean isSelected() {
        return this.get(WebElement::isSelected);
    }

    public void pressKey(Keys ... keys) {
        this.perform(e -> e.sendKeys((CharSequence[])keys));
    }

    public void select(String value) {
        this.perform(e -> {
            this.click();
            List options = e.findElements(By.tagName((String)"option"));
            Optional<ElementAction> option = options.stream().map(o -> new ElementAction(this.browserAction, (WebElement)o)).filter(s -> s.text().trim().equalsIgnoreCase(value)).findFirst();
            if (option.isPresent()) {
                option.get().click();
            }
        });
    }

    public String text() {
        return this.get(WebElement::getText);
    }

    public StringSubject verifyAttribute(String attribute) {
        return Truth.assertThat((String)this.attribute(attribute));
    }

    public BooleanSubject verifyDisplayed() {
        return (BooleanSubject)Truth.assertThat((Boolean)this.isDisplayed()).named("Is Displayed?", new Object[0]);
    }

    public BooleanSubject verifyEnabled() {
        return (BooleanSubject)Truth.assertThat((Boolean)this.isEnabled()).named("Is Enabled?", new Object[0]);
    }

    public BooleanSubject verifySelected() {
        return (BooleanSubject)Truth.assertThat((Boolean)this.isSelected()).named("Is Selected?", new Object[0]);
    }

    public StringSubject verifyText() {
        return Truth.assertThat((String)this.text());
    }

    public void waitUntilAttributeIs(String attribute, String value) {
        if (this.useBy) {
            this.waitUntilLocatorAttributeIs(attribute, value);
        } else {
            this.wait.until((Function)ExpectedConditions.attributeToBe((WebElement)this.element, (String)attribute, (String)value));
        }
    }

    public void waitUntilClickable() {
        if (this.useBy) {
            this.waitUntilLocatorClickable();
        } else {
            this.wait.until((Function)ExpectedConditions.elementToBeClickable((WebElement)this.element));
        }
    }

    public void waitUntilInvisible() {
        if (this.useBy) {
            this.waitUntilLocatorInvisible();
        } else {
            this.wait.until((Function)ExpectedConditions.invisibilityOf((WebElement)this.element));
        }
    }

    public void waitUntilVisible() {
        if (this.useBy) {
            this.waitUntilLocatorVisible();
        } else {
            this.wait.until((Function)ExpectedConditions.visibilityOf((WebElement)this.element));
        }
    }

    private <T> T get(Function<WebElement, T> func) {
        this.prepareForAction("green");
        return func.apply(this.element);
    }

    private void highlight(String color) {
        if (!this.alreadyHighlighted) {
            this.style = this.element.getAttribute("style");
            this.browserAction.executeScript("arguments[0].setAttribute('style', arguments[1] + arguments[2]);", this.element, this.style, MessageFormat.format("color: {0}; border: 3px solid {0};", color));
        }
    }

    private void perform(Consumer<WebElement> action) {
        this.prepareForAction("red");
        action.accept(this.element);
    }

    private void prepareForAction(String color) {
        this.waitUntilVisible();
        this.highlight(color);
        ElementAction.pause(this.delays.getHighlight());
        this.unhighlight();
    }

    private void unhighlight() {
        if (!this.alreadyHighlighted) {
            this.browserAction.executeScript("arguments[0].setAttribute('style', arguments[1]);", this.element, this.style);
            this.alreadyHighlighted = true;
        }
    }

    private void waitUntilLocatorAttributeIs(String attribute, String value) {
        this.wait.until((Function)ExpectedConditions.attributeToBe((By)this.by, (String)attribute, (String)value));
    }

    private void waitUntilLocatorClickable() {
        this.element = (WebElement)this.wait.until((Function)ExpectedConditions.elementToBeClickable((By)this.by));
    }

    private void waitUntilLocatorInvisible() {
        this.wait.until((Function)ExpectedConditions.invisibilityOfElementLocated((By)this.by));
    }

    private void waitUntilLocatorVisible() {
        this.element = (WebElement)this.wait.until((Function)ExpectedConditions.visibilityOfElementLocated((By)this.by));
    }
}

