/*
 * Decompiled with CFR 0.152.
 */
package com.github.wasiqb.coteafs.selenium.constants;

import com.github.wasiqb.coteafs.selenium.core.enums.PlatformOs;

public class OS {
    private static final String NAME = System.getProperty("os.name").toLowerCase();

    public static boolean isMac() {
        return NAME.contains("mac");
    }

    public static boolean isUnix() {
        return NAME.contains("nix") || NAME.contains("nux") || NAME.contains("aix");
    }

    public static boolean isWindows() {
        return NAME.contains("win");
    }

    public static PlatformOs platform() {
        if (OS.isWindows()) {
            return PlatformOs.WINDOWS;
        }
        if (OS.isMac()) {
            return PlatformOs.MAC;
        }
        if (OS.isUnix()) {
            return PlatformOs.LINUX;
        }
        return null;
    }

    private OS() {
    }
}

