/*
 * Decompiled with CFR 0.152.
 */
package com.github.wasiqb.coteafs.selenium.core;

import com.github.wasiqb.coteafs.selenium.config.ConfigUtil;
import com.github.wasiqb.coteafs.selenium.config.DelaySetting;
import com.github.wasiqb.coteafs.selenium.config.PlaybackSetting;
import com.github.wasiqb.coteafs.selenium.config.ScreenResolution;
import com.github.wasiqb.coteafs.selenium.constants.OS;
import com.github.wasiqb.coteafs.selenium.core.BrowserActions;
import com.github.wasiqb.coteafs.selenium.core.driver.IWebDriver;
import com.github.wasiqb.coteafs.selenium.core.enums.ApplicationType;
import com.github.wasiqb.coteafs.selenium.core.enums.AvailableBrowser;
import com.github.wasiqb.coteafs.selenium.core.enums.Platform;
import com.github.wasiqb.coteafs.selenium.core.enums.PlatformOs;
import com.github.wasiqb.coteafs.selenium.core.enums.ScreenState;
import com.github.wasiqb.coteafs.selenium.listeners.DriverListner;
import io.github.bonigarcia.wdm.WebDriverManager;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeDriverService;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxDriverService;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.GeckoDriverService;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.ie.InternetExplorerDriverService;
import org.openqa.selenium.ie.InternetExplorerOptions;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.safari.SafariDriver;
import org.openqa.selenium.safari.SafariOptions;
import org.openqa.selenium.support.events.EventFiringWebDriver;
import org.openqa.selenium.support.events.WebDriverEventListener;
import org.testng.Assert;

public class Browser
implements IWebDriver {
    private static final ThreadLocal<EventFiringWebDriver> driverThread = new ThreadLocal();
    private static final Logger log = LogManager.getLogger(Browser.class);
    private String browserName;
    private final DriverListner listener = new DriverListner();

    private static WebDriver setupChromeDriver() {
        log.info("Setting up Chrome driver...");
        WebDriverManager.chromedriver().setup();
        ChromeOptions chromeOptions = new ChromeOptions();
        chromeOptions.addArguments(new String[]{"--dns-prefetch-disable"});
        if (ConfigUtil.appSetting().isHeadlessMode()) {
            chromeOptions.addArguments(new String[]{"--headless"});
        }
        chromeOptions.setCapability("acceptSslCerts", true);
        ChromeDriverService chromeService = ChromeDriverService.createDefaultService();
        return new ChromeDriver(chromeService, chromeOptions);
    }

    private static WebDriver setupDriver(AvailableBrowser browser) {
        switch (browser) {
            case CHROME: {
                return Browser.setupChromeDriver();
            }
            case FIREFOX: {
                return Browser.setupFirefoxDriver();
            }
            case IE: {
                return Browser.setupIeDriver();
            }
            case EDGE: {
                return Browser.setupEdgeDriver();
            }
        }
        return Browser.setupSafariDriver();
    }

    private static WebDriver setupEdgeDriver() {
        log.info("Setting up Edge driver...");
        WebDriverManager.edgedriver().setup();
        EdgeOptions options = new EdgeOptions();
        return new EdgeDriver(options);
    }

    private static WebDriver setupFirefoxDriver() {
        log.info("Setting up Firefox driver...");
        WebDriverManager.firefoxdriver().setup();
        DesiredCapabilities capabilities = new DesiredCapabilities();
        FirefoxOptions options = new FirefoxOptions((Capabilities)capabilities);
        GeckoDriverService firefoxService = GeckoDriverService.createDefaultService();
        return new FirefoxDriver((FirefoxDriverService)firefoxService, options);
    }

    private static WebDriver setupIeDriver() {
        log.info("Setting up Internet Explorer driver...");
        WebDriverManager.iedriver().setup();
        InternetExplorerOptions ieOptions = new InternetExplorerOptions();
        ieOptions.destructivelyEnsureCleanSession();
        ieOptions.setCapability("requireWindowFocus", true);
        ieOptions.setCapability("acceptSslCerts", true);
        InternetExplorerDriverService ieService = InternetExplorerDriverService.createDefaultService();
        if (!OS.isWindows()) {
            Assert.fail((String)"IE is not supported.");
        }
        if (ConfigUtil.appSetting().isHeadlessMode()) {
            log.warn("IE does not support headless mode. Hence, ignoring the same...");
        }
        return new InternetExplorerDriver(ieService, ieOptions);
    }

    private static WebDriver setupSafariDriver() {
        log.info("Setting up Safari driver...");
        if (!OS.isMac()) {
            Assert.fail((String)"Safari is not supported.");
        }
        if (ConfigUtil.appSetting().isHeadlessMode()) {
            log.warn("Safari does not support Headless mode. Hence, ignoring the same...");
        }
        SafariOptions options = new SafariOptions();
        return new SafariDriver(options);
    }

    @Override
    public ApplicationType getApplicationType() {
        return ApplicationType.WEB;
    }

    @Override
    public EventFiringWebDriver getDriver() {
        return driverThread.get();
    }

    @Override
    public Platform getPlatform() {
        return Platform.DESKTOP;
    }

    @Override
    public PlatformOs getPlatformOs() {
        return OS.platform();
    }

    @Override
    public BrowserActions perform() {
        return new BrowserActions(this.getDriver());
    }

    @Override
    public void setBrowserUnderTest(String browser) {
        this.browserName = browser;
    }

    @Override
    public void start() {
        log.info("Starting the browser...");
        String target = this.browserName;
        if (target == null) {
            target = System.getProperty("test.browser", ConfigUtil.appSetting().getBrowser().name());
        }
        AvailableBrowser browser = AvailableBrowser.valueOf(target.toUpperCase());
        WebDriver driver = Browser.setupDriver(browser);
        EventFiringWebDriver wd = new EventFiringWebDriver(driver);
        wd.register((WebDriverEventListener)this.listener);
        this.driver(wd);
        this.setupDriverOptions();
    }

    @Override
    public void stop() {
        log.info("Stopping the browser...");
        this.getDriver().quit();
        this.driver(null);
    }

    private void manageOptions(Consumer<WebDriver.Options> options) {
        options.accept(this.getDriver().manage());
    }

    private void manageTimeouts(Consumer<WebDriver.Timeouts> timeouts) {
        timeouts.accept(this.getDriver().manage().timeouts());
    }

    private void manageWindow(Consumer<WebDriver.Window> window) {
        window.accept(this.getDriver().manage().window());
    }

    private void setScreenSize(PlaybackSetting playback) {
        ScreenState state = playback.getScreenState();
        log.info("Setting screen size of Browser to {}...", (Object)state);
        switch (state) {
            case FULL_SCREEN: {
                this.manageWindow(WebDriver.Window::fullscreen);
                break;
            }
            case MAXIMIZED: {
                this.manageWindow(WebDriver.Window::maximize);
                break;
            }
            default: {
                ScreenResolution resolution = playback.getScreenResolution();
                log.info("Setting screen resolution to [{}]...", (Object)resolution);
                this.manageWindow(w -> w.setSize(new Dimension(resolution.getWidth(), resolution.getHeight())));
            }
        }
    }

    private void setupDriverOptions() {
        PlaybackSetting playback = ConfigUtil.appSetting().getPlayback();
        DelaySetting delays = playback.getDelays();
        this.manageTimeouts(t -> t.pageLoadTimeout(delays.getPageLoad(), TimeUnit.SECONDS));
        this.manageTimeouts(t -> t.setScriptTimeout(delays.getScriptLoad(), TimeUnit.SECONDS));
        this.manageTimeouts(t -> t.implicitlyWait(delays.getImplicit(), TimeUnit.SECONDS));
        this.manageOptions(WebDriver.Options::deleteAllCookies);
        this.setScreenSize(playback);
    }

    protected void driver(EventFiringWebDriver driver) {
        driverThread.set(driver);
    }
}

