/*
 * Decompiled with CFR 0.152.
 */
package com.github.wasiqb.coteafs.selenium.core;

import com.github.wasiqb.coteafs.selenium.config.ConfigUtil;
import com.github.wasiqb.coteafs.selenium.core.driver.IWebDriverActions;
import com.github.wasiqb.coteafs.selenium.core.enums.AlertDecision;
import com.google.common.truth.StringSubject;
import com.google.common.truth.Truth;
import java.time.Duration;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.openqa.selenium.Alert;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.events.EventFiringWebDriver;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class BrowserActions
implements IWebDriverActions {
    private final EventFiringWebDriver driver;
    private final WebDriverWait wait;

    public BrowserActions(EventFiringWebDriver driver) {
        this.driver = driver;
        this.wait = new WebDriverWait((WebDriver)driver, Duration.ofSeconds(ConfigUtil.appSetting().getPlayback().getDelays().getExplicit()));
    }

    @Override
    public String alert(AlertDecision decision) {
        Alert alert = (Alert)this.wait.until((Function)ExpectedConditions.alertIsPresent());
        String message = null;
        if (alert != null) {
            message = alert.getText();
            if (decision == AlertDecision.ACCEPT) {
                alert.accept();
            } else {
                alert.dismiss();
            }
        }
        return message;
    }

    @Override
    public void back() {
        this.perform(d -> d.navigate().back());
    }

    @Override
    public void deleteCookies() {
        this.perform(d -> d.manage().deleteAllCookies());
    }

    @Override
    public WebDriverWait driverWait() {
        return this.wait;
    }

    @Override
    public <T> T execute(String script, Object ... args) {
        return (T)this.get(d -> ((RemoteWebDriver)d.getWrappedDriver()).executeScript(script, args));
    }

    @Override
    public void forward() {
        this.perform(d -> d.navigate().forward());
    }

    @Override
    public boolean isClosed() {
        return this.get(d -> ((RemoteWebDriver)d.getWrappedDriver()).getSessionId() == null);
    }

    @Override
    public void navigateTo(String url) {
        this.perform(d -> d.navigate().to(url));
    }

    @Override
    public void refresh() {
        this.perform(d -> d.navigate().refresh());
    }

    @Override
    public byte[] saveScreenshot() {
        return this.get(d -> (byte[])((RemoteWebDriver)d.getWrappedDriver()).getScreenshotAs(OutputType.BYTES));
    }

    @Override
    public void switchFrame() {
        this.switchFrame(0);
    }

    @Override
    public void switchFrame(int index) {
        this.perform(d -> d.switchTo().frame(index));
    }

    @Override
    public void switchFrame(String nameOrId) {
        this.perform(d -> d.switchTo().frame(nameOrId));
    }

    @Override
    public void switchWindow() {
        this.perform(d -> d.switchTo().defaultContent());
    }

    @Override
    public void switchWindow(String title) {
        this.perform(d -> {
            String currentHandle = d.getWindowHandle();
            Set wins = d.getWindowHandles();
            for (String win : wins) {
                WebDriver w;
                if (currentHandle.equals(win) || !(w = d.switchTo().window(win)).getTitle().contains(title)) continue;
                return;
            }
        });
    }

    @Override
    public String title() {
        return this.get(WebDriver::getTitle);
    }

    @Override
    public StringSubject verifyAlertMessage(AlertDecision decision) {
        String actual = this.alert(decision);
        return Truth.assertThat((String)actual);
    }

    @Override
    public StringSubject verifyTitle() {
        return Truth.assertThat((String)this.title());
    }

    protected <E> E get(Function<EventFiringWebDriver, E> func) {
        return func.apply(this.driver);
    }

    protected void perform(Consumer<EventFiringWebDriver> action) {
        action.accept(this.driver);
    }

    EventFiringWebDriver driver() {
        return this.driver;
    }
}

