/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.service.payments.jsapi;

import com.wechat.pay.java.core.Config;
import com.wechat.pay.java.core.cipher.Signer;
import com.wechat.pay.java.core.http.HostName;
import com.wechat.pay.java.core.http.HttpClient;
import com.wechat.pay.java.core.util.NonceUtil;
import com.wechat.pay.java.service.payments.jsapi.JsapiService;
import com.wechat.pay.java.service.payments.jsapi.model.CloseOrderRequest;
import com.wechat.pay.java.service.payments.jsapi.model.PrepayRequest;
import com.wechat.pay.java.service.payments.jsapi.model.PrepayWithRequestPaymentResponse;
import com.wechat.pay.java.service.payments.jsapi.model.QueryOrderByIdRequest;
import com.wechat.pay.java.service.payments.jsapi.model.QueryOrderByOutTradeNoRequest;
import com.wechat.pay.java.service.payments.model.Transaction;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsapiServiceExtension {
    private final Signer signer;
    private final String signType;
    private final JsapiService jsapiService;
    private static final Logger logger = LoggerFactory.getLogger(JsapiServiceExtension.class);

    private JsapiServiceExtension(Config config, HttpClient httpClient, HostName hostName, String signType) {
        this.signer = config.createSigner();
        JsapiService.Builder builder = new JsapiService.Builder().config(config);
        this.signType = signType;
        if (httpClient != null) {
            builder.httpClient(httpClient);
        }
        if (hostName != null) {
            builder.hostName(hostName);
        }
        this.jsapiService = builder.build();
    }

    public PrepayWithRequestPaymentResponse prepayWithRequestPayment(PrepayRequest request) {
        String prepayId = this.jsapiService.prepay(request).getPrepayId();
        long timestamp = Instant.now().getEpochSecond();
        String nonceStr = NonceUtil.createNonce((int)32);
        String packageVal = "prepay_id=" + prepayId;
        String message = request.getAppid() + "\n" + timestamp + "\n" + nonceStr + "\n" + packageVal + "\n";
        logger.debug("Message for RequestPayment signatures is[{}]", (Object)message);
        String sign = this.signer.sign(message).getSign();
        PrepayWithRequestPaymentResponse response = new PrepayWithRequestPaymentResponse();
        response.setAppId(request.getAppid());
        response.setTimeStamp(String.valueOf(timestamp));
        response.setNonceStr(nonceStr);
        response.setPackageVal(packageVal);
        response.setSignType(this.signType);
        response.setPaySign(sign);
        return response;
    }

    public Transaction queryOrderById(QueryOrderByIdRequest request) {
        return this.jsapiService.queryOrderById(request);
    }

    public Transaction queryOrderByOutTradeNo(QueryOrderByOutTradeNoRequest request) {
        return this.jsapiService.queryOrderByOutTradeNo(request);
    }

    public void closeOrder(CloseOrderRequest request) {
        this.jsapiService.closeOrder(request);
    }

    public static class Builder {
        private Config config;
        private HttpClient httpClient;
        private HostName hostName;
        private String signType;

        public Builder config(Config config) {
            this.config = config;
            return this;
        }

        public Builder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public Builder hostName(HostName hostName) {
            this.hostName = hostName;
            return this;
        }

        public Builder signType(String signType) {
            this.signType = signType;
            return this;
        }

        public JsapiServiceExtension build() {
            return new JsapiServiceExtension(this.config, this.httpClient, this.hostName, this.signType == null ? "RSA" : this.signType);
        }
    }
}

