/*
 * Decompiled with CFR 0.152.
 */
package com.github.easydoc;

import com.github.easydoc.EasydocMojo;
import com.github.easydoc.exception.EasydocFatalException;
import java.io.File;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.regex.Matcher;
import org.jfrog.maven.annomojo.annotations.MojoParameter;

public class CommandLineMojoUtils {
    public static void injectMojoProperties(EasydocMojo mojo, String[] args) throws ArgException {
        try {
            HashSet<Field> injectedFields = new HashSet<Field>();
            for (String arg : args) {
                try {
                    String[] nameAndValue = arg.split("=");
                    if (nameAndValue.length != 2) {
                        throw new InvalidArgException(arg);
                    }
                    Field field = ((Object)((Object)mojo)).getClass().getDeclaredField(nameAndValue[0]);
                    field.setAccessible(true);
                    MojoParameter mojoParameterAnno = field.getAnnotation(MojoParameter.class);
                    if (mojoParameterAnno == null) {
                        throw new InvalidArgException(arg);
                    }
                    CommandLineMojoUtils.injectValue(mojo, field, nameAndValue[1]);
                    injectedFields.add(field);
                }
                catch (NoSuchFieldException e) {
                    throw new InvalidArgException(arg);
                }
            }
            for (Field field : ((Object)((Object)mojo)).getClass().getDeclaredFields()) {
                MojoParameter mojoParameterAnno;
                field.setAccessible(true);
                if (injectedFields.contains(field) || (mojoParameterAnno = field.getAnnotation(MojoParameter.class)) == null) continue;
                String expression = mojoParameterAnno.expression();
                if (expression != null && !expression.isEmpty()) {
                    CommandLineMojoUtils.injectValue(mojo, field, expression.replaceAll("\\$\\{basedir\\}", Matcher.quoteReplacement(new File("").getAbsolutePath())).replaceAll("\\$\\{project.build.directory\\}", "build").replaceAll("/", Matcher.quoteReplacement(File.separator)));
                    continue;
                }
                if (!mojoParameterAnno.required()) continue;
                throw new RequiredArgException(field.getName());
            }
        }
        catch (IllegalAccessException e) {
            throw new EasydocFatalException(e);
        }
    }

    private static void injectValue(EasydocMojo mojo, Field field, String value) throws IllegalAccessException {
        Class<?> type = field.getType();
        if (type.equals(File.class)) {
            field.set((Object)mojo, new File(value));
        } else {
            field.set((Object)mojo, value);
        }
    }

    public static class RequiredArgException
    extends ArgException {
        private static final long serialVersionUID = 4951693249353819692L;

        public RequiredArgException(String arg) {
            super("Missing required argument: " + arg);
        }
    }

    public static class InvalidArgException
    extends ArgException {
        private static final long serialVersionUID = 6537755470692441678L;

        public InvalidArgException(String arg) {
            super("Illegal argument: " + arg);
        }
    }

    public static abstract class ArgException
    extends Exception {
        private static final long serialVersionUID = 6015239894637628421L;

        public ArgException(String msg) {
            super(msg);
        }
    }
}

