/*
 * Decompiled with CFR 0.152.
 */
package com.github.easydoc;

import com.github.easydoc.FileAction;
import com.github.easydoc.ParseDocumentationFileAction;
import com.github.easydoc.exception.EasydocFatalException;
import com.github.easydoc.exception.FileActionException;
import com.github.easydoc.model.Model;
import com.github.easydoc.param.SourceBrowserParam;
import com.github.easydoc.semantics.EasydocSemantics;
import com.github.easydoc.semantics.methods.IndexTextMethod;
import com.github.easydoc.sourcebrowser.SourceBrowser;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.jfrog.maven.annomojo.annotations.MojoExecute;
import org.jfrog.maven.annomojo.annotations.MojoGoal;
import org.jfrog.maven.annomojo.annotations.MojoParameter;
import org.jfrog.maven.annomojo.annotations.MojoPhase;
import org.springframework.util.AntPathMatcher;

@MojoGoal(value="generate")
@MojoPhase(value="process-sources")
@MojoExecute(phase="process-sources")
public class EasydocMojo
extends AbstractMojo {
    @MojoParameter(required=true, expression="${project.build.directory}/easydoc")
    private File outputDirectory;
    @MojoParameter(required=true, expression="${basedir}/src")
    private File inputDirectory;
    @MojoParameter
    private List<String> excludes = new ArrayList<String>();
    @MojoParameter
    private List<String> includes;
    @MojoParameter
    private File customCss;
    @MojoParameter
    private SourceBrowserParam sourceBrowser;
    @MojoParameter(expression="${encoding}", defaultValue="${project.build.sourceEncoding}")
    private String encoding = Charset.defaultCharset().toString();
    private AntPathMatcher pathMatcher = new AntPathMatcher();
    @MojoParameter(required=true, expression="${basedir}")
    private File projectDirectory;
    private File currentDirectory = new File("");
    private Properties versionProperties = new Properties();
    @MojoParameter
    private Boolean generateIndex = true;
    @MojoParameter(expression="${project.name}")
    private String projectName;
    @MojoParameter
    private String defaultFormat = "html";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        block12: {
            try {
                this.excludes.add("**" + File.separator + ".*");
                this.versionProperties.load(((Object)((Object)this)).getClass().getResourceAsStream("/version.properties"));
                this.getLog().debug((CharSequence)("currentDirectory = " + this.currentDirectory.getAbsolutePath()));
                if (!this.inputDirectory.exists()) {
                    this.getLog().debug((CharSequence)"Input directory does not exist. Skipping execution.");
                    return;
                }
                Configuration freemarkerCfg = new Configuration();
                freemarkerCfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
                freemarkerCfg.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(((Object)((Object)this)).getClass(), "/templates"));
                Model model = new Model();
                ParseDocumentationFileAction fileAction = new ParseDocumentationFileAction(model, this.getLog());
                fileAction.setEncoding(this.encoding);
                File pomXml = new File(this.projectDirectory.getAbsoluteFile(), "pom.xml");
                pomXml = this.toRelativeFile(this.currentDirectory, pomXml);
                this.getLog().debug((CharSequence)("pomXml = " + pomXml + ", isFile = " + pomXml.isFile() + ", skipCheck = " + this.skipCheck(pomXml)));
                if (pomXml.isFile() && !this.skipCheck(pomXml)) {
                    fileAction.run(pomXml);
                }
                this.recurseDirectory(this.toRelativeFile(this.currentDirectory, this.inputDirectory), fileAction);
                if (model.getDocs().isEmpty()) {
                    this.getLog().debug((CharSequence)"No docs were found. Skipping execution.");
                    return;
                }
                EasydocSemantics semantics = new EasydocSemantics();
                semantics.setDefaultFormat(this.defaultFormat);
                EasydocSemantics.CompilationResult compilationResult = semantics.compileModel(model);
                if (compilationResult.isPositive()) {
                    Template template = freemarkerCfg.getTemplate("page.ftl");
                    this.outputDirectory.mkdirs();
                    BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.outputDirectory, "index.html")), this.encoding));
                    try {
                        Map<String, Object> freemarkerModel = compilationResult.getModel().toFreemarkerModel();
                        String cssContent = this.customCss != null ? FileUtils.readFileToString((File)this.customCss) : IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/css/easydoc.css"));
                        freemarkerModel.put("css", cssContent);
                        if (this.sourceBrowser != null) {
                            freemarkerModel.put("sourceBrowser", this.createSourceBrowser(this.sourceBrowser));
                        }
                        freemarkerModel.put("version", this.versionProperties.getProperty("version", ""));
                        freemarkerModel.put("encoding", this.encoding);
                        template.setEncoding(this.encoding);
                        freemarkerModel.put("indexText", new IndexTextMethod());
                        freemarkerModel.put("generateIndex", this.generateIndex);
                        freemarkerModel.put("projectName", this.projectName);
                        template.process(freemarkerModel, (Writer)out);
                        break block12;
                    }
                    finally {
                        out.close();
                    }
                }
                for (String error : compilationResult.getErrors()) {
                    this.getLog().error((CharSequence)error);
                }
                throw new MojoExecutionException("Failed to compile documentation. See the error log.");
            }
            catch (MojoExecutionException e) {
                throw e;
            }
            catch (Exception e) {
                throw new EasydocFatalException(e);
            }
        }
    }

    private SourceBrowser createSourceBrowser(SourceBrowserParam sbParam) {
        try {
            if (sbParam.getType() != null) {
                return sbParam.getType().getSourceBrowserClass().getConstructor(SourceBrowserParam.class).newInstance(sbParam);
            }
            throw new IllegalArgumentException("The required parameter sourceBrowser/type is not specified");
        }
        catch (Exception e) {
            throw new EasydocFatalException(e);
        }
    }

    private void recurseDirectory(File dir, FileAction action) {
        for (File file : dir.listFiles()) {
            if (this.skipCheck(file)) continue;
            if (!file.canRead()) {
                this.getLog().warn((CharSequence)("File " + file.getAbsolutePath() + " is not readable."));
                continue;
            }
            if (file.isFile()) {
                try {
                    action.run(file);
                }
                catch (FileActionException e) {
                    this.getLog().warn((CharSequence)"Error", (Throwable)e);
                }
                continue;
            }
            if (!file.isDirectory()) continue;
            this.recurseDirectory(file, action);
        }
    }

    private File toRelativeFile(File currentDirectory, File file) {
        String cdAbsolutePath;
        String absolutePath = file.getAbsolutePath();
        if (!absolutePath.startsWith(cdAbsolutePath = currentDirectory.getAbsolutePath())) {
            return file;
        }
        if (absolutePath.equals(cdAbsolutePath)) {
            return currentDirectory;
        }
        String relativePath = absolutePath.substring(cdAbsolutePath.length());
        if (relativePath.startsWith(File.separator)) {
            if (relativePath.length() > File.separator.length()) {
                return new File(relativePath.substring(File.separator.length()));
            }
            return currentDirectory;
        }
        return new File(relativePath);
    }

    private boolean skipCheck(File file) {
        boolean skip = false;
        if (this.includes != null && !file.isDirectory()) {
            skip = true;
            for (String include : this.includes) {
                skip &= !this.pathMatcher.match(include, file.getPath());
            }
        }
        if (skip) {
            return true;
        }
        for (String exclude : this.excludes) {
            if (!this.pathMatcher.match(exclude, file.getPath())) continue;
            return true;
        }
        return false;
    }
}

