/*
 * Decompiled with CFR 0.152.
 */
package com.github.easydoc;

import com.github.easydoc.EasydocParser;
import com.github.easydoc.FileAction;
import com.github.easydoc.exception.FileActionException;
import com.github.easydoc.model.Doc;
import com.github.easydoc.model.Model;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.antlr.runtime.RecognitionException;
import org.apache.maven.plugin.logging.Log;

public class ParseDocumentationFileAction
implements FileAction {
    private final Log log;
    private Model model;
    private String encoding;

    public ParseDocumentationFileAction(Model model, Log log) {
        this.model = model;
        this.log = log;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public void run(File file) throws FileActionException {
        try {
            this.log.debug((CharSequence)("File: " + file.getAbsolutePath()));
            List<Doc> docs = this.parseFile(file);
            if (docs.size() > 0) {
                this.log.info((CharSequence)String.format("%d docs found in file %s", docs.size(), file.getAbsolutePath()));
            }
            this.log.debug((CharSequence)("Resulting docs: " + docs));
            this.model.addDocs(docs);
        }
        catch (Exception e) {
            throw new FileActionException("Failed to process file " + file.getAbsolutePath(), e);
        }
    }

    private List<Doc> parseFile(File file) throws IOException, RecognitionException {
        EasydocParser parser = this.encoding != null ? new EasydocParser(file, this.encoding) : new EasydocParser(file);
        List<Doc> docs = parser.document();
        this.log.debug((CharSequence)docs.toString());
        return docs;
    }
}

