/*
 * Decompiled with CFR 0.152.
 */
package com.github.easydoc.model;

import com.github.easydoc.model.Directive;
import com.github.easydoc.model.DocItem;
import com.github.easydoc.model.DocTextItem;
import com.github.easydoc.model.SourceLink;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Doc
implements Comparable<Doc> {
    private List<DocItem> items = new ArrayList<DocItem>();
    private Map<String, String> params = new HashMap<String, String>();
    private String id;
    private Doc parent;
    private List<Doc> children = new ArrayList<Doc>();
    private SourceLink sourceLink;
    private Integer weight;
    private List<Directive> directives = Collections.emptyList();

    public String getText() {
        StringBuilder sb = new StringBuilder();
        for (DocItem item : this.items) {
            sb.append(item.getText());
        }
        return sb.toString();
    }

    public void setText(String text) {
        this.setItems(Collections.singletonList(new DocTextItem(text)));
    }

    public void setItems(List<DocItem> items) {
        this.items = items;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Doc getParent() {
        return this.parent;
    }

    public void setParent(Doc parent) {
        this.parent = parent;
    }

    public List<Doc> getChildren() {
        return this.children;
    }

    public void addChild(Doc child) {
        this.children.add(child);
    }

    public SourceLink getSourceLink() {
        return this.sourceLink;
    }

    public void setSourceLink(SourceLink sourceLink) {
        this.sourceLink = sourceLink;
    }

    public Integer getWeight() {
        return this.weight;
    }

    public void setWeight(Integer weight) {
        this.weight = weight;
    }

    public List<Directive> getDirectives() {
        return this.directives;
    }

    public void setDirectives(List<Directive> directives) {
        this.directives = directives;
    }

    public boolean hasChildrenWithIds() {
        for (Doc doc : this.children) {
            if (doc.getId() == null) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return String.format("Doc [text=%s, params=%s, id=%s, parent=%s, sourceLink=%s, weight=%d]", this.items, this.params, this.id, this.parent != null ? this.parent.getId() : null, this.sourceLink, this.weight);
    }

    @Override
    public int compareTo(Doc doc) {
        Integer thisWeight = this.weight != null ? this.weight : 0;
        return thisWeight.compareTo(doc.getWeight() != null ? doc.getWeight() : 0);
    }
}

