/*
 * Decompiled with CFR 0.152.
 */
package com.github.easydoc.model;

import com.github.easydoc.model.Doc;
import com.github.easydoc.model.criteria.DocSearchCriteria;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Model {
    private List<Doc> docs = new ArrayList<Doc>();

    public List<Doc> findDocs(DocSearchCriteria criteria) {
        ArrayList<Doc> ret = new ArrayList<Doc>();
        for (Doc doc : this.docs) {
            if (!criteria.satisfies(doc)) continue;
            ret.add(doc);
        }
        return ret;
    }

    public List<Doc> getDocs() {
        return this.docs;
    }

    public void addDocs(List<Doc> docs) {
        this.docs.addAll(docs);
    }

    public Map<String, Object> toFreemarkerModel() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("docs", this.docs);
        ret.put("doctree", this.docTree());
        return ret;
    }

    private Collection<Doc> docTree() {
        ArrayList<Doc> ret = new ArrayList<Doc>();
        for (Doc doc : this.docs) {
            if (doc.getParent() != null) continue;
            ret.add(doc);
        }
        Collections.sort(ret);
        return ret;
    }
}

